/*
 * Decompiled with CFR 0.152.
 */
package io.lamma;

import io.lamma.Date;
import io.lamma.Duration;
import io.lamma.Weekday;
import io.lamma.Weekday$Friday$;
import io.lamma.Weekday$Monday$;
import io.lamma.Weekday$Saturday$;
import io.lamma.Weekday$Sunday$;
import io.lamma.Weekday$Thursday$;
import io.lamma.Weekday$Tuesday$;
import io.lamma.Weekday$Wednesday$;
import java.util.Calendar;
import java.util.TimeZone;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JavaDateUtil$ {
    public static final JavaDateUtil$ MODULE$;
    private final int OneDay;

    static {
        new JavaDateUtil$();
    }

    public Calendar calendar(Date d) {
        return this.calendar(d.yyyy(), d.mm(), d.dd());
    }

    public Calendar calendar(int yyyy, int mm, int dd) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(yyyy, mm - 1, dd);
        cal.set(11, 0);
        cal.clear(10);
        cal.clear(12);
        cal.clear(13);
        cal.clear(14);
        return cal;
    }

    public Date date(Calendar cal) {
        return new Date(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public Date plus(Date d, Duration duration) {
        Duration duration2;
        block6: {
            Calendar cal;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            cal = this.calendar(d);
                            duration2 = duration;
                            if (!(duration2 instanceof Duration.DayDuration)) break block2;
                            Duration.DayDuration dayDuration = (Duration.DayDuration)duration2;
                            int n = dayDuration.n();
                            cal.add(5, n);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(duration2 instanceof Duration.WeekDuration)) break block4;
                        Duration.WeekDuration weekDuration = (Duration.WeekDuration)duration2;
                        int n = weekDuration.n();
                        cal.add(5, n * 7);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(duration2 instanceof Duration.MonthDuration)) break block5;
                    Duration.MonthDuration monthDuration = (Duration.MonthDuration)duration2;
                    int n = monthDuration.n();
                    cal.add(2, n);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(duration2 instanceof Duration.YearDuration)) break block6;
                Duration.YearDuration yearDuration = (Duration.YearDuration)duration2;
                int n = yearDuration.n();
                cal.add(1, n);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return this.date(cal);
        }
        throw new MatchError((Object)duration2);
    }

    public Date minus(Date d, Duration duration) {
        Duration duration2;
        block6: {
            Calendar cal;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            cal = this.calendar(d);
                            duration2 = duration;
                            if (!(duration2 instanceof Duration.DayDuration)) break block2;
                            Duration.DayDuration dayDuration = (Duration.DayDuration)duration2;
                            int n = dayDuration.n();
                            cal.add(5, -n);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(duration2 instanceof Duration.WeekDuration)) break block4;
                        Duration.WeekDuration weekDuration = (Duration.WeekDuration)duration2;
                        int n = weekDuration.n();
                        cal.add(5, -n * 7);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(duration2 instanceof Duration.MonthDuration)) break block5;
                    Duration.MonthDuration monthDuration = (Duration.MonthDuration)duration2;
                    int n = monthDuration.n();
                    cal.add(2, -n);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(duration2 instanceof Duration.YearDuration)) break block6;
                Duration.YearDuration yearDuration = (Duration.YearDuration)duration2;
                int n = yearDuration.n();
                cal.add(1, -n);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return this.date(cal);
        }
        throw new MatchError((Object)duration2);
    }

    public final int OneDay() {
        return 86400000;
    }

    public int daysBetween(Date d1, Date d2) {
        long d1Millis = this.calendar(d1).getTimeInMillis();
        long d2Millis = this.calendar(d2).getTimeInMillis();
        return (int)((d2Millis - d1Millis) / 86400000L);
    }

    public int monthsBetween(Date d1, Date d2) {
        Calendar cal1 = this.calendar(d1);
        Calendar cal2 = this.calendar(d2);
        int unadjusted = (cal2.get(1) - cal1.get(1)) * 12 + cal2.get(2) - cal1.get(2);
        cal1.add(2, unadjusted);
        return cal1.getTimeInMillis() > cal2.getTimeInMillis() ? unadjusted - 1 : unadjusted;
    }

    public int yearsBetween(Date d1, Date d2) {
        Calendar cal1 = this.calendar(d1);
        Calendar cal2 = this.calendar(d2);
        int unadjusted = cal2.get(1) - cal1.get(1);
        cal1.add(1, unadjusted);
        return cal1.getTimeInMillis() > cal2.getTimeInMillis() ? unadjusted - 1 : unadjusted;
    }

    public Weekday dayOfWeek(Date d) {
        Product product;
        int n = this.calendar(d).get(7);
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 7: {
                product = Weekday$Saturday$.MODULE$;
                break;
            }
            case 6: {
                product = Weekday$Friday$.MODULE$;
                break;
            }
            case 5: {
                product = Weekday$Thursday$.MODULE$;
                break;
            }
            case 4: {
                product = Weekday$Wednesday$.MODULE$;
                break;
            }
            case 3: {
                product = Weekday$Tuesday$.MODULE$;
                break;
            }
            case 2: {
                product = Weekday$Monday$.MODULE$;
                break;
            }
            case 1: {
                product = Weekday$Sunday$.MODULE$;
            }
        }
        return product;
    }

    public int dayOfMonth(Date d) {
        return this.calendar(d).get(5);
    }

    public int maxDayOfMonth(Date d) {
        return this.calendar(d).getActualMaximum(5);
    }

    public int dayOfYear(Date d) {
        return this.calendar(d).get(6);
    }

    public int maxDayOfYear(Date d) {
        return this.calendar(d).getActualMaximum(6);
    }

    private JavaDateUtil$() {
        MODULE$ = this;
    }
}

