/*
 * Decompiled with CFR 0.152.
 */
package io.leego.unique.client.autoconfigure;

import feign.Feign;
import feign.hystrix.HystrixFeign;
import io.leego.unique.client.CachedUniqueClient;
import io.leego.unique.client.SimpleUniqueClient;
import io.leego.unique.client.UniqueClient;
import io.leego.unique.client.autoconfigure.UniqueClientProperties;
import io.leego.unique.client.codec.ResponseErrorDecoder;
import io.leego.unique.client.service.UniqueService;
import io.leego.unique.client.service.UniqueServiceFeignClient;
import io.leego.unique.mybatis.support.interceptor.AutoSeqInterceptor;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@EnableFeignClients(basePackages={"io.leego.unique"})
@ComponentScan(basePackages={"io.leego.unique"})
@ConditionalOnProperty(value={"spring.unique.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={UniqueClientProperties.class})
public class UniqueAutoConfiguration {
    @Bean
    public ResponseErrorDecoder responseErrorDecoder() {
        return new ResponseErrorDecoder();
    }

    @Bean
    @ConditionalOnMissingBean
    public UniqueClient uniqueClient(UniqueServiceFeignClient uniqueServiceFeignClient, UniqueClientProperties properties) {
        if (properties.getCache() != null && properties.getCache().isEnabled()) {
            return new CachedUniqueClient((UniqueService)uniqueServiceFeignClient, properties.getCache().getSize(), properties.getTimeout());
        }
        return new SimpleUniqueClient((UniqueService)uniqueServiceFeignClient);
    }

    @Configuration
    @ConditionalOnClass(value={AutoSeqInterceptor.class})
    @ConditionalOnBean(value={SqlSessionFactory.class})
    @ConditionalOnProperty(value={"spring.unique.mybatis.plugin.enabled"})
    @EnableConfigurationProperties(value={UniqueClientProperties.class})
    @AutoConfigureAfter(value={MybatisAutoConfiguration.class})
    protected static class UniqueMybatisAutoConfiguration {
        @Autowired(required=false)
        private List<SqlSessionFactory> sqlSessionFactoryList;

        protected UniqueMybatisAutoConfiguration() {
        }

        @Bean
        public AutoSeqInterceptor autoSeqInterceptor(UniqueClient uniqueClient) {
            AutoSeqInterceptor interceptor = new AutoSeqInterceptor(uniqueClient);
            if (this.sqlSessionFactoryList != null) {
                for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
                    boolean flag = true;
                    List interceptors = sqlSessionFactory.getConfiguration().getInterceptors();
                    for (Interceptor o : interceptors) {
                        if (o == null || AutoSeqInterceptor.class != o.getClass()) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)interceptor);
                }
            }
            return interceptor;
        }
    }

    @Configuration
    @EnableHystrix
    @ConditionalOnProperty(value={"spring.unique.hystrix.enabled"})
    @EnableConfigurationProperties(value={UniqueClientProperties.class})
    protected static class UniqueHystrixAutoConfiguration {
        protected UniqueHystrixAutoConfiguration() {
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        public Feign.Builder feignHystrixBuilder() {
            return HystrixFeign.builder();
        }
    }
}

