/*
 * Decompiled with CFR 0.152.
 */
package io.leego.unique.client.service;

import feign.hystrix.FallbackFactory;
import io.leego.unique.client.service.UniqueServiceFeignClient;
import io.leego.unique.common.Result;
import io.leego.unique.common.Segment;
import io.leego.unique.common.exception.ObtainErrorException;
import org.springframework.stereotype.Component;

@Component
public class UniqueServiceFallbackFactory
implements FallbackFactory<UniqueServiceFeignClient> {
    public UniqueServiceFeignClient create(final Throwable cause) {
        return new UniqueServiceFeignClient(){

            @Override
            public Result<Long> next(String key) {
                throw new ObtainErrorException("Failed to obtain the sequence \"" + key + "\"", cause);
            }

            @Override
            public Result<Segment> next(String key, int size) {
                throw new ObtainErrorException("Failed to obtain the sequence \"" + key + "\", size: " + size, cause);
            }
        };
    }
}

