/*
 * Decompiled with CFR 0.152.
 */
package com.netaporter.uri.parsing;

import com.netaporter.uri.QueryString;
import com.netaporter.uri.Uri;
import com.netaporter.uri.config.UriConfig;
import com.netaporter.uri.parsing.DefaultUriParser;
import java.net.URISyntaxException;
import org.parboiled2.ParseError;
import org.parboiled2.Parser;
import org.parboiled2.ParserInput;
import org.parboiled2.ParserInput$;
import org.parboiled2.Position;
import org.parboiled2.Rule;
import org.parboiled2.support.Unpack$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import shapeless.;
import shapeless.HNil;

public final class UriParser$ {
    public static final UriParser$ MODULE$;

    static {
        new UriParser$();
    }

    public Uri parse(String s, UriConfig config) {
        DefaultUriParser parser = new DefaultUriParser((ParserInput)ParserInput$.MODULE$.apply(s), config);
        boolean bl = false;
        Failure failure = null;
        DefaultUriParser p = parser;
        Try try_ = (Try)p.__run((Function0)new Serializable(p){
            public static final long serialVersionUID = 0L;
            private final DefaultUriParser p$1;

            public final Rule<HNil, .colon.colon<Uri, HNil>> apply() {
                return this.p$1._uri();
            }
            {
                this.p$1 = p$1;
            }
        }, Parser.DeliveryScheme$.MODULE$.Try(Unpack$.MODULE$.single()));
        if (try_ instanceof Success) {
            Uri uri;
            Success success = (Success)try_;
            Uri uri2 = uri = (Uri)success.value();
            return uri2;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable pe = failure.exception();
            if (pe instanceof ParseError) {
                ParseError parseError = (ParseError)pe;
                Position position = parseError.position();
                Seq formatTraces = parseError.traces();
                throw new URISyntaxException(s, new StringBuilder().append((Object)"Invalid URI could not be parsed. ").append((Object)formatTraces).toString(), position.index());
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public QueryString parseQuery(String s, UriConfig config) {
        String withQuestionMark = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(s)).head()) == '?' ? s : new StringBuilder().append((Object)"?").append((Object)s).toString();
        DefaultUriParser parser = new DefaultUriParser((ParserInput)ParserInput$.MODULE$.apply(withQuestionMark), config);
        boolean bl = false;
        Failure failure = null;
        DefaultUriParser p = parser;
        Try try_ = (Try)p.__run((Function0)new Serializable(p){
            public static final long serialVersionUID = 0L;
            private final DefaultUriParser p$2;

            public final Rule<HNil, .colon.colon<QueryString, HNil>> apply() {
                return this.p$2._queryString();
            }
            {
                this.p$2 = p$2;
            }
        }, Parser.DeliveryScheme$.MODULE$.Try(Unpack$.MODULE$.single()));
        if (try_ instanceof Success) {
            QueryString queryString;
            Success success = (Success)try_;
            QueryString queryString2 = queryString = (QueryString)success.value();
            return queryString2;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable pe = failure.exception();
            if (pe instanceof ParseError) {
                ParseError parseError = (ParseError)pe;
                Position position = parseError.position();
                Seq formatTraces = parseError.traces();
                throw new URISyntaxException(s, new StringBuilder().append((Object)"Invalid URI could not be parsed. ").append((Object)formatTraces).toString(), position.index());
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public Tuple2<String, Option<String>> parseQueryParam(String s, UriConfig config) {
        DefaultUriParser parser = new DefaultUriParser((ParserInput)ParserInput$.MODULE$.apply(s), config);
        boolean bl = false;
        Failure failure = null;
        DefaultUriParser p = parser;
        Try try_ = (Try)p.__run((Function0)new Serializable(p){
            public static final long serialVersionUID = 0L;
            private final DefaultUriParser p$3;

            public final Rule<HNil, .colon.colon<Tuple2<String, Option<String>>, HNil>> apply() {
                return this.p$3._queryParamOrTok();
            }
            {
                this.p$3 = p$3;
            }
        }, Parser.DeliveryScheme$.MODULE$.Try(Unpack$.MODULE$.single()));
        if (try_ instanceof Success) {
            Tuple2 queryParam;
            Success success = (Success)try_;
            Tuple2 tuple2 = queryParam = (Tuple2)success.value();
            return tuple2;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable pe = failure.exception();
            if (pe instanceof ParseError) {
                ParseError parseError = (ParseError)pe;
                Position position = parseError.position();
                Seq formatTraces = parseError.traces();
                throw new URISyntaxException(s, new StringBuilder().append((Object)"Invalid URI could not be parsed. ").append((Object)formatTraces).toString(), position.index());
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    private UriParser$() {
        MODULE$ = this;
    }
}

