/*
 * Decompiled with CFR 0.152.
 */
package io.lemonlabs.uri;

import cats.Show;
import cats.kernel.Eq;
import cats.kernel.Order;
import io.lemonlabs.uri.AbsoluteUrl;
import io.lemonlabs.uri.AbsoluteUrl$;
import io.lemonlabs.uri.Authority;
import io.lemonlabs.uri.Authority$;
import io.lemonlabs.uri.DataUrl$;
import io.lemonlabs.uri.Host;
import io.lemonlabs.uri.MediaType;
import io.lemonlabs.uri.Path;
import io.lemonlabs.uri.Path$SlashTermination$AddForEmptyPath$;
import io.lemonlabs.uri.QueryString;
import io.lemonlabs.uri.QueryString$;
import io.lemonlabs.uri.RootlessPath$;
import io.lemonlabs.uri.SimpleUrlWithoutAuthority$;
import io.lemonlabs.uri.Uri;
import io.lemonlabs.uri.Url;
import io.lemonlabs.uri.UrlPath;
import io.lemonlabs.uri.UrlWithoutAuthority;
import io.lemonlabs.uri.config.UriConfig;
import io.lemonlabs.uri.typesafe.Fragment;
import java.util.Arrays;
import java.util.Base64;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public final class DataUrl
implements Product,
Uri,
Url,
UrlWithoutAuthority {
    private final MediaType mediaType;
    private final boolean base64;
    private final byte[] data;
    private final UriConfig config;
    private final String scheme;

    public static DataUrl apply(MediaType mediaType, boolean bl, byte[] byArray, UriConfig uriConfig) {
        return DataUrl$.MODULE$.apply(mediaType, bl, byArray, uriConfig);
    }

    public static Eq<DataUrl> eqDataUrl() {
        return DataUrl$.MODULE$.eqDataUrl();
    }

    public static DataUrl fromBase64(MediaType mediaType, String string, UriConfig uriConfig) {
        return DataUrl$.MODULE$.fromBase64(mediaType, string, uriConfig);
    }

    public static DataUrl fromPercentEncoded(MediaType mediaType, String string, UriConfig uriConfig) {
        return DataUrl$.MODULE$.fromPercentEncoded(mediaType, string, uriConfig);
    }

    public static Order<DataUrl> orderDataUrl() {
        return DataUrl$.MODULE$.orderDataUrl();
    }

    public static DataUrl parse(CharSequence charSequence, UriConfig uriConfig) {
        return DataUrl$.MODULE$.parse(charSequence, uriConfig);
    }

    public static Option<DataUrl> parseOption(CharSequence charSequence, UriConfig uriConfig) {
        return DataUrl$.MODULE$.parseOption(charSequence, uriConfig);
    }

    public static Try<DataUrl> parseTry(CharSequence charSequence, UriConfig uriConfig) {
        return DataUrl$.MODULE$.parseTry(charSequence, uriConfig);
    }

    public static Show<DataUrl> showDataUrl() {
        return DataUrl$.MODULE$.showDataUrl();
    }

    public static DataUrl unapply(DataUrl dataUrl) {
        return DataUrl$.MODULE$.unapply(dataUrl);
    }

    public static UriConfig parse$default$2(CharSequence charSequence) {
        return DataUrl$.MODULE$.parse$default$2(charSequence);
    }

    public static UriConfig parseOption$default$2(CharSequence charSequence) {
        return DataUrl$.MODULE$.parseOption$default$2(charSequence);
    }

    public static UriConfig parseTry$default$2(CharSequence charSequence) {
        return DataUrl$.MODULE$.parseTry$default$2(charSequence);
    }

    public static UriConfig fromBase64$default$3(MediaType mediaType, String string) {
        return DataUrl$.MODULE$.fromBase64$default$3(mediaType, string);
    }

    public static UriConfig fromPercentEncoded$default$3(MediaType mediaType, String string) {
        return DataUrl$.MODULE$.fromPercentEncoded$default$3(mediaType, string);
    }

    public static UriConfig $lessinit$greater$default$4(MediaType mediaType, boolean bl, byte[] byArray) {
        return DataUrl$.MODULE$.$lessinit$greater$default$4(mediaType, bl, byArray);
    }

    public DataUrl(MediaType mediaType, boolean base64, byte[] data, UriConfig config) {
        this.mediaType = mediaType;
        this.base64 = base64;
        this.data = data;
        this.config = config;
        this.scheme = "data";
    }

    public boolean canEqual(Object that) {
        return that instanceof DataUrl;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "DataUrl";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this._2());
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "mediaType";
                break;
            }
            case 1: {
                string = "base64";
                break;
            }
            case 2: {
                string = "data";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public boolean base64() {
        return this.base64;
    }

    public byte[] data() {
        return this.data;
    }

    @Override
    public UriConfig config() {
        return this.config;
    }

    @Override
    public DataUrl self() {
        return this;
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public Option<String> schemeOption() {
        return Some$.MODULE$.apply((Object)this.scheme());
    }

    @Override
    public QueryString query() {
        return QueryString$.MODULE$.empty(this.config());
    }

    @Override
    public Option<String> fragment() {
        return None$.MODULE$;
    }

    @Override
    public UrlPath path() {
        return RootlessPath$.MODULE$.fromParts((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.pathString(this.config().withNoEncoding())}), this.config());
    }

    public String dataAsString() {
        return new String(this.data(), this.mediaType().charset());
    }

    public String pathString(UriConfig c) {
        String string;
        String base64Str;
        String string2 = base64Str = this.base64() ? ";base64" : "";
        if (this.base64()) {
            String b64Encoded = Base64.getEncoder().encodeToString(this.data());
            string = c.pathEncoder().encode(b64Encoded, this.mediaType().charset());
        } else {
            string = c.pathEncoder().encode(this.data(), this.mediaType().charset());
        }
        String dataStr = string;
        return new StringBuilder(1).append(this.mediaType().toString()).append(base64Str).append(",").append(dataStr).toString();
    }

    @Override
    public UrlWithoutAuthority withScheme(String scheme) {
        return scheme.equalsIgnoreCase("data") ? this : SimpleUrlWithoutAuthority$.MODULE$.apply(scheme, this.path(), this.query(), this.fragment(), this.config());
    }

    @Override
    public AbsoluteUrl withHost(Host host) {
        return AbsoluteUrl$.MODULE$.apply(this.scheme(), Authority$.MODULE$.apply(host, this.config()), this.path().toAbsoluteOrEmpty(), this.query(), this.fragment(), this.config());
    }

    @Override
    public DataUrl withPath(UrlPath path) {
        return DataUrl$.MODULE$.parse(new StringBuilder(1).append(this.scheme()).append(":").append(path.toString()).toString(), this.config());
    }

    public AbsoluteUrl withPort(int port) {
        return AbsoluteUrl$.MODULE$.apply(this.scheme(), Authority$.MODULE$.apply("", port, this.config()), this.path().toAbsoluteOrEmpty(), this.query(), this.fragment(), this.config());
    }

    @Override
    public AbsoluteUrl withAuthority(Authority authority) {
        return AbsoluteUrl$.MODULE$.apply(this.scheme(), authority, this.path().toAbsoluteOrEmpty(), this.query(), this.fragment(), this.config());
    }

    @Override
    public <T> DataUrl withFragment(T fragment, Fragment<T> evidence$27) {
        return this;
    }

    @Override
    public DataUrl withQueryString(QueryString query) {
        return this;
    }

    @Override
    public DataUrl withConfig(UriConfig config) {
        return DataUrl$.MODULE$.apply(this.mediaType(), this.base64(), this.data(), config);
    }

    @Override
    public String toStringWithConfig(UriConfig c) {
        return new StringBuilder(1).append(this.scheme()).append(":").append(this.pathString(c)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof DataUrl)) return false;
        DataUrl other = (DataUrl)object;
        if (!other.canEqual(this)) return false;
        MediaType mediaType = this.mediaType();
        MediaType mediaType2 = other.mediaType();
        if (mediaType == null) {
            if (mediaType2 != null) {
                return false;
            }
        } else if (!((Object)mediaType).equals(mediaType2)) return false;
        if (this.base64() != other.base64()) return false;
        if (!Arrays.equals(this.data(), other.data())) return false;
        return true;
    }

    public int hashCode() {
        return 41 * (41 * (41 + this.mediaType().hashCode()) + BoxesRunTime.boxToBoolean((boolean)this.base64()).hashCode()) + Arrays.hashCode(this.data());
    }

    @Override
    public boolean equalsUnordered(Uri other) {
        DataUrl dataUrl = this;
        Uri uri = other;
        return !(dataUrl != null ? !((Object)dataUrl).equals(uri) : uri != null);
    }

    @Override
    public DataUrl normalize(boolean removeEmptyPathParts, Path.SlashTermination slashTermination) {
        return this;
    }

    @Override
    public boolean normalize$default$1() {
        return false;
    }

    @Override
    public Path.SlashTermination normalize$default$2() {
        return Path$SlashTermination$AddForEmptyPath$.MODULE$;
    }

    public DataUrl copy(MediaType mediaType, boolean base64, byte[] data, UriConfig config) {
        return new DataUrl(mediaType, base64, data, config);
    }

    public MediaType copy$default$1() {
        return this.mediaType();
    }

    public boolean copy$default$2() {
        return this.base64();
    }

    public byte[] copy$default$3() {
        return this.data();
    }

    public MediaType _1() {
        return this.mediaType();
    }

    public boolean _2() {
        return this.base64();
    }

    public byte[] _3() {
        return this.data();
    }
}

