/*
 * Decompiled with CFR 0.152.
 */
package io.lemonlabs.uri;

import cats.Show;
import cats.Show$;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.package$;
import io.lemonlabs.uri.IpV4;
import io.lemonlabs.uri.IpV6;
import io.lemonlabs.uri.config.UriConfig;
import io.lemonlabs.uri.config.UriConfig$;
import io.lemonlabs.uri.parsing.UrlParser$;
import java.io.Serializable;
import scala.Char$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;

public final class IpV6$
implements Serializable {
    private static final Eq eqIpV6;
    private static final Show showIpV6;
    private static final Order orderIpV6;
    public static final IpV6$ MODULE$;

    private IpV6$() {
    }

    static {
        MODULE$ = new IpV6$();
        eqIpV6 = package$.MODULE$.Eq().fromUniversalEquals();
        showIpV6 = Show$.MODULE$.fromToString();
        orderIpV6 = package$.MODULE$.Order().by((Function1 & Serializable)_$7 -> _$7.pieces(), Eq$.MODULE$.catsKernelOrderForVector((Order)Eq$.MODULE$.catsKernelInstancesForChar()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IpV6$.class);
    }

    public IpV6 apply(char piece1, char piece2, char piece3, char piece4, char piece5, char piece6, char piece7, char piece8, UriConfig conf) {
        return new IpV6(piece1, piece2, piece3, piece4, piece5, piece6, piece7, piece8, conf);
    }

    public IpV6 unapply(IpV6 x$1) {
        return x$1;
    }

    public String toString() {
        return "IpV6";
    }

    public UriConfig $lessinit$greater$default$9(char piece1, char piece2, char piece3, char piece4, char piece5, char piece6, char piece7, char piece8) {
        return UriConfig$.MODULE$.default();
    }

    public IpV6 apply(int piece1, int piece2, int piece3, int piece4, int piece5, int piece6, int piece7, int piece8) {
        Predef$.MODULE$.require(piece1 >= 0 && piece2 >= 0 && piece3 >= 0 && piece4 >= 0 && piece5 >= 0 && piece6 >= 0 && piece7 >= 0 && piece8 >= 0, this::apply$$anonfun$3);
        Predef$.MODULE$.require(piece1 <= 65535 && piece2 <= 65535 && piece3 <= 65535 && piece4 <= 65535 && piece5 <= 65535 && piece6 <= 65535 && piece7 <= 65535 && piece8 <= 65535, this::apply$$anonfun$4);
        char c = (char)piece1;
        char c2 = (char)piece2;
        char c3 = (char)piece3;
        char c4 = (char)piece4;
        char c5 = (char)piece5;
        char c6 = (char)piece6;
        char c7 = (char)piece7;
        char c8 = (char)piece8;
        return new IpV6(c, c2, c3, c4, c5, c6, c7, c8, this.$lessinit$greater$default$9(c, c2, c3, c4, c5, c6, c7, c8));
    }

    private int hexToInt(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public IpV6 apply(String piece1, String piece2, String piece3, String piece4, String piece5, String piece6, String piece7, String piece8) {
        return this.apply(this.hexToInt(piece1), this.hexToInt(piece2), this.hexToInt(piece3), this.hexToInt(piece4), this.hexToInt(piece5), this.hexToInt(piece6), this.hexToInt(piece7), this.hexToInt(piece8));
    }

    public IpV6 apply(String piece1, String piece2, String piece3, String piece4, String piece5, String piece6, IpV4 piece78) {
        Tuple2<Object, Object> tuple2 = piece78.toIpV6Pieces();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        char piece7 = BoxesRunTime.unboxToChar((Object)tuple2._1());
        char piece8 = BoxesRunTime.unboxToChar((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)piece7), (Object)BoxesRunTime.boxToCharacter((char)piece8));
        char piece72 = BoxesRunTime.unboxToChar((Object)tuple22._1());
        char piece82 = BoxesRunTime.unboxToChar((Object)tuple22._2());
        return this.apply(this.hexToInt(piece1), this.hexToInt(piece2), this.hexToInt(piece3), this.hexToInt(piece4), this.hexToInt(piece5), this.hexToInt(piece6), Char$.MODULE$.char2int(piece72), Char$.MODULE$.char2int(piece82));
    }

    public IpV6 fromIntPieces(Seq<Object> pieces) {
        Predef$.MODULE$.require(pieces.length() == 8, this::fromIntPieces$$anonfun$1);
        return this.apply(BoxesRunTime.unboxToInt((Object)pieces.apply(0)), BoxesRunTime.unboxToInt((Object)pieces.apply(1)), BoxesRunTime.unboxToInt((Object)pieces.apply(2)), BoxesRunTime.unboxToInt((Object)pieces.apply(3)), BoxesRunTime.unboxToInt((Object)pieces.apply(4)), BoxesRunTime.unboxToInt((Object)pieces.apply(5)), BoxesRunTime.unboxToInt((Object)pieces.apply(6)), BoxesRunTime.unboxToInt((Object)pieces.apply(7)));
    }

    public IpV6 fromHexPieces(Seq<String> pieces) {
        Predef$.MODULE$.require(pieces.length() == 8, this::fromHexPieces$$anonfun$1);
        return this.apply((String)pieces.apply(0), (String)pieces.apply(1), (String)pieces.apply(2), (String)pieces.apply(3), (String)pieces.apply(4), (String)pieces.apply(5), (String)pieces.apply(6), (String)pieces.apply(7));
    }

    public IpV6 fromHexPiecesAndIpV4(Seq<String> pieces, IpV4 ls32) {
        Predef$.MODULE$.require(pieces.length() == 6, this::fromHexPiecesAndIpV4$$anonfun$1);
        return this.apply((String)pieces.apply(0), (String)pieces.apply(1), (String)pieces.apply(2), (String)pieces.apply(3), (String)pieces.apply(4), (String)pieces.apply(5), ls32);
    }

    public Try<IpV6> parseTry(CharSequence s, UriConfig config) {
        return UrlParser$.MODULE$.parseIpV6(s.toString(), config);
    }

    public UriConfig parseTry$default$2(CharSequence s) {
        return UriConfig$.MODULE$.default();
    }

    public Option<IpV6> parseOption(CharSequence s, UriConfig config) {
        return this.parseTry(s, config).toOption();
    }

    public UriConfig parseOption$default$2(CharSequence s) {
        return UriConfig$.MODULE$.default();
    }

    public IpV6 parse(CharSequence s, UriConfig config) {
        return (IpV6)this.parseTry(s, config).get();
    }

    public UriConfig parse$default$2(CharSequence s) {
        return UriConfig$.MODULE$.default();
    }

    public IpV6 localhost() {
        return this.apply(0, 0, 0, 0, 0, 0, 0, 1);
    }

    public Eq<IpV6> eqIpV6() {
        return eqIpV6;
    }

    public Show<IpV6> showIpV6() {
        return showIpV6;
    }

    public Order<IpV6> orderIpV6() {
        return orderIpV6;
    }

    private final String apply$$anonfun$3() {
        return "IPv6 pieces must be >= 0";
    }

    private final String apply$$anonfun$4() {
        return new StringBuilder(23).append("IPv6 Pieces must be <= ").append(65535).toString();
    }

    private final String fromIntPieces$$anonfun$1() {
        return "IPv6 must be made up of eight pieces";
    }

    private final String fromHexPieces$$anonfun$1() {
        return "IPv6 must be made up of eight pieces";
    }

    private final String fromHexPiecesAndIpV4$$anonfun$1() {
        return "IPv6 must be made up of six pieces when least-significant 32bits are an IPv4";
    }
}

