/*
 * Decompiled with CFR 0.152.
 */
package io.lemonlabs.uri.parsing;

import cats.parse.Parser;
import cats.parse.Parser$;
import cats.parse.Parser0;
import io.lemonlabs.uri.Urn;
import io.lemonlabs.uri.Urn$;
import io.lemonlabs.uri.UrnPath;
import io.lemonlabs.uri.UrnPath$;
import io.lemonlabs.uri.config.UriConfig;
import io.lemonlabs.uri.parsing.UriParser;
import io.lemonlabs.uri.parsing.UriParsingException;
import io.lemonlabs.uri.parsing.UrnParser$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public class UrnParser
implements UriParser {
    private Parser _alpha_num;
    private Parser _hex_digit;
    private Parser _unreserved;
    private Parser _pct_encoded;
    private Parser _sub_delims;
    private Parser _p_char;
    private final String input;
    private final UriConfig conf;
    private final Function2 extractUrnPath;
    private final Function1 extractUrn;

    public static UrnParser apply(CharSequence charSequence, UriConfig uriConfig) {
        return UrnParser$.MODULE$.apply(charSequence, uriConfig);
    }

    public static UriConfig $lessinit$greater$default$2(String string) {
        return UrnParser$.MODULE$.$lessinit$greater$default$2(string);
    }

    public static UriConfig apply$default$2(CharSequence charSequence) {
        return UrnParser$.MODULE$.apply$default$2(charSequence);
    }

    public static UriConfig parseUrn$default$2(String string) {
        return UrnParser$.MODULE$.parseUrn$default$2(string);
    }

    public static UriConfig parseUrnPath$default$2(String string) {
        return UrnParser$.MODULE$.parseUrnPath$default$2(string);
    }

    public UrnParser(String input, UriConfig conf) {
        this.input = input;
        this.conf = conf;
        UriParser.$init$(this);
        this.extractUrnPath = (Function2 & Serializable)(nid, nss) -> {
            if (nid.length() < 2) {
                throw new UriParsingException(new StringBuilder(60).append("URN nid '").append((String)nid).append("' is too short. Must be at least two character long").toString());
            }
            if (StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(nid)) == '-' || StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(nid)) == '-') {
                throw new UriParsingException(new StringBuilder(41).append("URN nid '").append((String)nid).append("' cannot start or end with a '-'").toString());
            }
            return UrnPath$.MODULE$.apply((String)nid, conf.pathDecoder().decode((String)nss), conf);
        };
        this.extractUrn = (Function1 & Serializable)urnPath -> Urn$.MODULE$.apply((UrnPath)urnPath, conf);
        Statics.releaseFence();
    }

    public Parser _alpha_num() {
        return this._alpha_num;
    }

    public Parser _hex_digit() {
        return this._hex_digit;
    }

    public Parser _unreserved() {
        return this._unreserved;
    }

    public Parser _pct_encoded() {
        return this._pct_encoded;
    }

    public Parser _sub_delims() {
        return this._sub_delims;
    }

    public Parser _p_char() {
        return this._p_char;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_alpha_num_$eq(Parser x$0) {
        this._alpha_num = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_hex_digit_$eq(Parser x$0) {
        this._hex_digit = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_unreserved_$eq(Parser x$0) {
        this._unreserved = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_pct_encoded_$eq(Parser x$0) {
        this._pct_encoded = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_sub_delims_$eq(Parser x$0) {
        this._sub_delims = x$0;
    }

    @Override
    public void io$lemonlabs$uri$parsing$UriParser$_setter_$_p_char_$eq(Parser x$0) {
        this._p_char = x$0;
    }

    public String input() {
        return this.input;
    }

    public Parser0<String> _nid() {
        return this._alpha_num().$bar(Parser$.MODULE$.char('-')).rep0().string();
    }

    public Parser<String> _nss() {
        return this._p_char().$tilde(this._p_char().$bar(Parser$.MODULE$.char('/')).rep0()).string();
    }

    public Parser<UrnPath> _urn_path() {
        Parser0 parser0 = this._nid().with1();
        return Parser.With1$.MODULE$.flatMap$extension(parser0, (Function1 & Serializable)nid -> Parser$.MODULE$.char(':').flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return this._nss().map((Function1 & Serializable)nss -> (UrnPath)this.extractUrnPath().apply(nid, nss));
        }));
    }

    public Parser<Urn> _urn() {
        return Parser$.MODULE$.string("urn:").$times$greater((Parser0)this._urn_path().map(this.extractUrn()));
    }

    public Function2<String, String, UrnPath> extractUrnPath() {
        return this.extractUrnPath;
    }

    public Function1<UrnPath, Urn> extractUrn() {
        return this.extractUrn;
    }

    public <T> Try<T> mapParseError(Function0<Either<Parser.Error, T>> t, Function0<String> name) {
        return Try$.MODULE$.apply(t).flatMap((Function1 & Serializable)x$1 -> {
            Success success;
            Either either = x$1;
            if (either instanceof Left) {
                Parser.Error error = (Parser.Error)((Left)either).value();
                success = Failure$.MODULE$.apply((Throwable)new UriParsingException(new StringBuilder(30).append("Invalid ").append(name.apply()).append(" could not be parsed. ").append(error).toString()));
            } else if (either instanceof Right) {
                Object value = ((Right)either).value();
                success = Success$.MODULE$.apply(value);
            } else {
                throw new MatchError((Object)either);
            }
            return success;
        });
    }

    public Try<UrnPath> parseUrnPath() {
        return this.mapParseError(this::parseUrnPath$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrnParser::parseUrnPath$$anonfun$2));
    }

    public Try<Urn> parseUrn() {
        return this.mapParseError(this::parseUrn$$anonfun$1, (Function0<String>)((Function0 & Serializable)UrnParser::parseUrn$$anonfun$2));
    }

    private final Either parseUrnPath$$anonfun$1() {
        return this._urn_path().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseUrnPath$$anonfun$2() {
        return "URN Path";
    }

    private final Either parseUrn$$anonfun$1() {
        return this._urn().$less$times(Parser$.MODULE$.end()).parseAll(this.input());
    }

    private static final String parseUrn$$anonfun$2() {
        return "URN";
    }
}

