/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.ShadowedInternalKafkaConsumer;
import org.apache.spark.sql.kafka010.ShadowedKafkaDataConsumer;
import org.apache.spark.sql.kafka010.ShadowedKafkaDataConsumer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ShadowedKafkaDataConsumer$
implements Logging {
    public static final ShadowedKafkaDataConsumer$ MODULE$;
    private LinkedHashMap<ShadowedKafkaDataConsumer.CacheKey, ShadowedInternalKafkaConsumer> cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ShadowedKafkaDataConsumer$();
    }

    private LinkedHashMap cache$lzycompute() {
        ShadowedKafkaDataConsumer$ shadowedKafkaDataConsumer$ = this;
        synchronized (shadowedKafkaDataConsumer$) {
            if (!this.bitmap$0) {
                SparkConf conf = SparkEnv$.MODULE$.get().conf();
                int capacity = conf.getInt("spark.sql.kafkaConsumerCache.capacity", 64);
                this.cache = new LinkedHashMap<ShadowedKafkaDataConsumer.CacheKey, ShadowedInternalKafkaConsumer>(capacity){
                    public final int capacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<ShadowedKafkaDataConsumer.CacheKey, ShadowedInternalKafkaConsumer> entry) {
                        if (entry.getValue().inUse()) return false;
                        if (this.size() <= this.capacity$1) return false;
                        ShadowedKafkaDataConsumer$.MODULE$.logWarning((Function0<String>)new Serializable(this, entry){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final Map.Entry entry$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaConsumer cache hitting max capacity of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.capacity$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.entry$1 = entry$1;
                            }
                        });
                        try {
                            entry.getValue().close();
                            return true;
                        }
                        catch (SparkException sparkException) {
                            ShadowedKafkaDataConsumer$.MODULE$.logError((Function0<String>)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error closing earliest Kafka consumer for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }, sparkException);
                        }
                        return true;
                    }
                    {
                        this.capacity$1 = capacity$1;
                        super(capacity$1, 0.75f, true);
                    }
                };
                this.bitmap$0 = true;
            }
            return this.cache;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private LinkedHashMap<ShadowedKafkaDataConsumer.CacheKey, ShadowedInternalKafkaConsumer> cache() {
        return this.bitmap$0 ? this.cache : this.cache$lzycompute();
    }

    public synchronized ShadowedKafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> kafkaParams, boolean useCache) {
        Product product;
        ObjectRef newInternalConsumer$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        ShadowedKafkaDataConsumer.CacheKey key = new ShadowedKafkaDataConsumer.CacheKey(topicPartition, kafkaParams);
        ShadowedInternalKafkaConsumer existingInternalConsumer = this.cache().get(key);
        if (TaskContext$.MODULE$.get() != null && TaskContext$.MODULE$.get().attemptNumber() >= 1) {
            if (existingInternalConsumer != null) {
                if (existingInternalConsumer.inUse()) {
                    existingInternalConsumer.markedForClose_$eq(true);
                } else {
                    existingInternalConsumer.close();
                }
            }
            this.cache().remove(key);
            product = new ShadowedKafkaDataConsumer.NonCachedShadowedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
        } else if (useCache) {
            if (existingInternalConsumer == null) {
                this.cache().put(key, this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
                this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0).inUse_$eq(true);
                product = new ShadowedKafkaDataConsumer.CachedShadowedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
            } else if (existingInternalConsumer.inUse()) {
                product = new ShadowedKafkaDataConsumer.NonCachedShadowedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
            } else {
                existingInternalConsumer.inUse_$eq(true);
                product = new ShadowedKafkaDataConsumer.CachedShadowedKafkaDataConsumer(existingInternalConsumer);
            }
        } else {
            product = new ShadowedKafkaDataConsumer.NonCachedShadowedKafkaDataConsumer(this.newInternalConsumer$1(topicPartition, kafkaParams, newInternalConsumer$lzy, bitmap$0));
        }
        return product;
    }

    public void org$apache$spark$sql$kafka010$ShadowedKafkaDataConsumer$$release(ShadowedInternalKafkaConsumer intConsumer) {
        ShadowedKafkaDataConsumer$ shadowedKafkaDataConsumer$ = this;
        synchronized (shadowedKafkaDataConsumer$) {
            Object object;
            ShadowedKafkaDataConsumer.CacheKey key = new ShadowedKafkaDataConsumer.CacheKey(intConsumer.topicPartition(), intConsumer.kafkaParams());
            ShadowedInternalKafkaConsumer cachedIntConsumer = this.cache().get(key);
            if (intConsumer == cachedIntConsumer) {
                if (intConsumer.markedForClose()) {
                    intConsumer.close();
                    object = this.cache().remove(key);
                } else {
                    intConsumer.inUse_$eq(false);
                    object = BoxedUnit.UNIT;
                }
            } else {
                intConsumer.close();
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Released a supposedly cached consumer that was not found in the cache"})).s((Seq)Nil$.MODULE$);
                    }
                });
                object = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final ShadowedInternalKafkaConsumer newInternalConsumer$lzycompute$1(TopicPartition topicPartition$1, Map kafkaParams$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        ShadowedKafkaDataConsumer$ shadowedKafkaDataConsumer$ = this;
        synchronized (shadowedKafkaDataConsumer$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                newInternalConsumer$lzy$1.elem = new ShadowedInternalKafkaConsumer(topicPartition$1, kafkaParams$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (ShadowedInternalKafkaConsumer)newInternalConsumer$lzy$1.elem;
        }
    }

    private final ShadowedInternalKafkaConsumer newInternalConsumer$1(TopicPartition topicPartition$1, Map kafkaParams$1, ObjectRef newInternalConsumer$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.newInternalConsumer$lzycompute$1(topicPartition$1, kafkaParams$1, newInternalConsumer$lzy$1, bitmap$0$1) : (ShadowedInternalKafkaConsumer)newInternalConsumer$lzy$1.elem;
    }

    private ShadowedKafkaDataConsumer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

