/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.proxy;

import io.leopard.web.servlet.CookieUtil;
import io.leopard.web.servlet.RequestUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebserverProxy {
    private static final Log logger = LogFactory.getLog(WebserverProxy.class);
    private static final Set<String> IGNORE_HEADER = new HashSet<String>();

    protected static String getResinIp(HttpServletRequest request) {
        String resinIp = request.getParameter("resinIp");
        if (resinIp == null || resinIp.length() == 0) {
            resinIp = CookieUtil.getCookie((String)"resinIp", (HttpServletRequest)request);
        }
        return resinIp;
    }

    public static boolean proxy(String uri, HttpServletRequest request, ServletResponse res) throws IOException {
        if (!uri.startsWith("/monitor/")) {
            return false;
        }
        String resinIp = WebserverProxy.getResinIp(request);
        if (resinIp == null || resinIp.length() == 0) {
            return false;
        }
        try {
            WebserverProxy.doProxy(resinIp, uri, request, res);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            WebserverProxy.outputError(res, e.toString());
        }
        return true;
    }

    protected static void outputError(ServletResponse res, String message) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("var Cookie = {\n");
        sb.append("\t\"addCookie\" : function(name, value) {\n");
        sb.append("\tvar str = name + \"=\" + escape(value);\n");
        sb.append("\tstr += \";path=/\";\n");
        sb.append("\tdocument.cookie = str;\n");
        sb.append("}\n");
        sb.append("}\n");
        sb.append("function selectResinServer(resinIp) {\n");
        sb.append("\tCookie.addCookie(\"resinIp\", resinIp);\n");
        sb.append("\tdocument.location.href = document.location.href;\n");
        sb.append("}\n");
        sb.append("</script>\n");
        sb.append("<a href=\"javascript:selectResinServer('');\">\u8bbf\u95ee\u9ed8\u8ba4\u670d\u52a1\u5668</a>\n");
        res.setContentType("text/html; charset=UTF-8");
        String body = sb.toString();
        res.setContentLength(body.getBytes().length);
        PrintWriter out = res.getWriter();
        ((Writer)out).write(body);
        ((Writer)out).flush();
    }

    protected static String doProxy(String resinIp, String uri, HttpServletRequest request, ServletResponse res) throws IOException {
        String str;
        if (!"get".equalsIgnoreCase(request.getMethod())) {
            throw new IllegalArgumentException("\u53ea\u652f\u6301get\u65b9\u5f0f\u8bf7\u6c42.");
        }
        String proxyIp = RequestUtil.getProxyIp((HttpServletRequest)request);
        String host = request.getServerName();
        String url = WebserverProxy.getUrl(resinIp, uri, request);
        int time = 60000;
        URL oUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)oUrl.openConnection();
        conn.setConnectTimeout(time);
        conn.setReadTimeout(time);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Host", host);
        conn.setRequestProperty("X-Real-IP", proxyIp);
        conn.setRequestProperty("User-Agent", "LeopardResinProxy");
        conn.setDoOutput(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder sb = new StringBuilder();
        while ((str = in.readLine()) != null) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(str);
        }
        in.close();
        conn.disconnect();
        String body = sb.toString();
        int contentLength = body.getBytes().length;
        HttpServletResponse response = (HttpServletResponse)res;
        int status = conn.getResponseCode();
        response.setStatus(status);
        res.setContentLength(contentLength);
        PrintWriter out = response.getWriter();
        ((Writer)out).write(body);
        ((Writer)out).flush();
        logger.info((Object)("done proxy, proxyIp:" + proxyIp + " url:" + url));
        return body;
    }

    protected static String getUrl(String resinIp, String uri, HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(resinIp + ":8081").append(uri);
        Map map = request.getParameterMap();
        if (map != null && !map.isEmpty()) {
            StringBuilder queryString = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                String[] values;
                String name = (String)entry.getKey();
                if ("resinIp".equals(name)) continue;
                for (String value : values = (String[])entry.getValue()) {
                    if (queryString.length() > 0) {
                        queryString.append("&");
                    }
                    queryString.append(name).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
            }
            if (queryString.length() > 0) {
                sb.append("?").append(queryString.toString());
            }
        }
        return sb.toString();
    }

    static {
        IGNORE_HEADER.add(null);
        IGNORE_HEADER.add("Content-Length");
    }
}

