/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.view;

import io.leopard.json.Json;
import io.leopard.web.view.AbstractView;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AjaxView
extends AbstractView {
    private String status;
    private String message;
    private Object data;

    public AjaxView() {
    }

    public AjaxView(Object data) {
        this(data, false);
    }

    public AjaxView(Object data, boolean checkXss) {
        this("200", data);
        if (checkXss) {
            this.checkXss(data);
        }
    }

    private void checkXss(Object data) {
    }

    public AjaxView(String status, Object data) {
        this.status = status;
        this.data = data;
        this.message = "";
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getContentType() {
        return "text/plain; charset=UTF-8";
    }

    @Override
    public String getBody(HttpServletRequest request, HttpServletResponse response) {
        boolean format = "true".equals(request.getParameter("format"));
        String dateFormat = request.getParameter("dateFormat");
        Map<String, Object> result = this.getResult();
        return new JsonOutput().output(result, format, dateFormat, request);
    }

    protected Map<String, Object> getResult() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("status", this.getStatus());
        map.put("message", this.message);
        map.put("data", this.getData());
        return map;
    }

    public static class JsonOutput {
        public String output(Object data, boolean format, String dateFormat, HttpServletRequest request) {
            if (format) {
                return Json.toFormatJson((Object)data);
            }
            return Json.toJson((Object)data);
        }
    }
}

