/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.JstlView;

public abstract class FileCacheView
extends ModelAndView {
    public FileCacheView(String viewName) {
        super.setView((View)this.createView(viewName));
    }

    protected JstlView createView(String viewName) {
        return new JstlView("/WEB-INF/jsp/" + viewName + ".jsp"){

            protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
                ServletOutputStream output = response.getOutputStream();
                ServletContext servletContext = request.getServletContext();
                super.setServletContext(servletContext);
                CacheResponseWrapper cacheResponseWrapper = new CacheResponseWrapper(response);
                super.renderMergedOutputModel(model, request, (HttpServletResponse)cacheResponseWrapper);
                byte[] data = cacheResponseWrapper.getResponseData();
                String content = new String(data);
                FileCacheView.this.response(content);
                output.write(data);
                output.flush();
            }
        };
    }

    public abstract void response(String var1);

    protected static class CacheResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private ServletOutputStream out = new WapperedOutputStream(this.buffer);
        private PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.buffer, "UTF-8"));

        public CacheResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.out;
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            this.out.flush();
            this.writer.flush();
        }

        public void reset() {
            this.buffer.reset();
        }

        public byte[] getResponseData() throws IOException {
            this.flushBuffer();
            return this.buffer.toByteArray();
        }

        protected static class WapperedOutputStream
        extends ServletOutputStream {
            private ByteArrayOutputStream bos = null;

            public WapperedOutputStream(ByteArrayOutputStream stream) throws IOException {
                this.bos = stream;
            }

            public void write(int b) throws IOException {
                this.bos.write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener arg0) {
            }
        }
    }
}

