/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.view;

import java.util.Calendar;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.util.JavaScriptUtils;

public class JstlFunctions {
    public static final int HIGHEST_SPECIAL = 62;
    public static char[][] specialCharactersRepresentation = new char[63][];
    private static final Log logger;
    static String regex;
    static Pattern p;

    public static String escape(String input) {
        return JstlFunctions.escapeXml(input);
    }

    public static String escapeXml(String input) {
        if (input == null) {
            return "";
        }
        int start = 0;
        int length = input.length();
        char[] arrayBuffer = input.toCharArray();
        StringBuffer escapedBuffer = null;
        for (int i = 0; i < length; ++i) {
            char[] escaped;
            char c = arrayBuffer[i];
            if (c > '>' || (escaped = specialCharactersRepresentation[c]) == null) continue;
            if (start == 0) {
                escapedBuffer = new StringBuffer(length + 5);
            }
            if (start < i) {
                escapedBuffer.append(arrayBuffer, start, i - start);
            }
            start = i + 1;
            escapedBuffer.append(escaped);
        }
        if (start == 0) {
            return input;
        }
        if (start < length) {
            escapedBuffer.append(arrayBuffer, start, length - start);
        }
        return escapedBuffer.toString();
    }

    public static String noescape(String input) {
        return input;
    }

    public static String escapeJavascript(String str) {
        return JavaScriptUtils.javaScriptEscape((String)str);
    }

    public static String escapeJavascriptParam(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(34) != -1) {
            Exception e = new Exception("invalid js param:" + str);
            logger.error((Object)e.getMessage(), (Throwable)e);
            str = str.replace("\"", "");
        }
        return JavaScriptUtils.javaScriptEscape((String)str);
    }

    public static String escapeHTMLTags(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(60) == -1 && str.indexOf(62) == -1 && str.indexOf(34) == -1) {
            return str;
        }
        int stringLength = str.length();
        StringBuilder buf = new StringBuilder((int)((double)stringLength * 1.1));
        block5: for (int i = 0; i < stringLength; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    continue block5;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block5;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static Integer b2i(Boolean flag) {
        if (flag.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public static Integer unixTime(String datetime) {
        long timestamp = JstlFunctions.timestamp(datetime);
        int time = (int)(timestamp / 1000L);
        return time;
    }

    public static Long timestamp(String datetime) {
        Calendar cal = Calendar.getInstance();
        int year = Integer.parseInt(datetime.substring(0, 4));
        int month = Integer.parseInt(datetime.substring(5, 7));
        int day = Integer.parseInt(datetime.substring(8, 10));
        int hour = Integer.parseInt(datetime.substring(11, 13));
        int minute = Integer.parseInt(datetime.substring(14, 16));
        int second = Integer.parseInt(datetime.substring(17, 19));
        cal.set(year, month - 1, day, hour, minute, second);
        if (datetime.length() > 19) {
            int mill = Integer.parseInt(datetime.substring(20));
            cal.set(14, mill);
        } else {
            cal.set(14, 0);
        }
        long timestamp = cal.getTimeInMillis();
        return timestamp;
    }

    public static String replaceSpace(String content) {
        if (content == null) {
            return null;
        }
        char c = '\u2029';
        content.replace(c, '\n');
        content = content.replace("  ", "\u3000");
        content = content.replace("\r", "");
        content = content.replace("\n", "<br/>");
        return content;
    }

    public static String space(Integer length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append("&nbsp;");
        }
        return sb.toString();
    }

    static {
        JstlFunctions.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        JstlFunctions.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        JstlFunctions.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        JstlFunctions.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        JstlFunctions.specialCharactersRepresentation[39] = "&#039;".toCharArray();
        logger = LogFactory.getLog(JstlFunctions.class);
        regex = "(http|ftp|https)://[^\u4e00-\u9fa5]*";
        p = Pattern.compile(regex);
    }
}

