/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.view.trynb;

import io.leopard.json.Json;
import io.leopard.mvc.trynb.ErrorUtil;
import io.leopard.mvc.trynb.model.TrynbInfo;
import io.leopard.mvc.trynb.resolver.TrynbResolver;
import io.leopard.web.view.AbstractView;
import io.leopard.web.view.StatusCodeException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;

public class JsonViewTrynbResolver
implements TrynbResolver {
    public ModelAndView resolveView(HttpServletRequest request, HttpServletResponse response, HandlerMethod handler, Exception exception, TrynbInfo trynbInfo) {
        ResponseBody body = (ResponseBody)handler.getMethodAnnotation(ResponseBody.class);
        if (body == null) {
            return null;
        }
        ErrorJsonView jsonView = new ErrorJsonView();
        if (exception instanceof StatusCodeException) {
            StatusCodeException e = (StatusCodeException)((Object)exception);
            jsonView.setStatus(e.getStatus());
        } else {
            jsonView.setStatus(trynbInfo.getStatusCode());
        }
        jsonView.setMessage(trynbInfo.getMessage());
        if (trynbInfo.isTrynbMessage() || trynbInfo.isApiMessage() || trynbInfo.isTranslate()) {
            jsonView.setOriginalMessage(ErrorUtil.parseMessage((Throwable)exception));
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            jsonView.setDetailMessage(exception.getMessage());
        }
        jsonView.setException(exception.getClass().getName());
        return jsonView;
    }

    protected static boolean isValidCallback(String callback) {
        if (StringUtils.isEmpty((String)callback)) {
            throw new IllegalArgumentException("\u53c2\u6570callback\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        boolean isValidCallback = callback.matches("^[a-zA-Z0-9_\\.]+$");
        return isValidCallback;
    }

    public class ErrorJsonView
    extends AbstractView {
        private Map<String, Object> map = new LinkedHashMap<String, Object>();

        public void setStatus(String status) {
            this.map.put("status", status);
        }

        public void setDetailMessage(String detailMessage) {
            this.map.put("detailMessage", detailMessage);
        }

        public void setOriginalMessage(String originalMessage) {
            this.map.put("originalMessage", originalMessage);
        }

        public void setMessage(String message) {
            this.map.put("message", message);
        }

        public void setException(String exception) {
            this.map.put("exception", exception);
        }

        @Override
        public String getContentType() {
            return "text/plain; charset=UTF-8";
        }

        @Override
        public String getBody(HttpServletRequest request, HttpServletResponse response) {
            String json = Json.toFormatJson(this.map);
            request.setAttribute("result.json", (Object)json);
            String callback = request.getParameter("callback");
            if (StringUtils.isNotEmpty((String)callback)) {
                if (!JsonViewTrynbResolver.isValidCallback(callback)) {
                    callback = "callback";
                }
                return callback + "(" + json + ");";
            }
            return json;
        }
    }
}

