/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam;

import io.leopard.web.xparam.PageIdXParam;
import io.leopard.web.xparam.SizeXParam;
import io.leopard.web.xparam.XParam;
import io.leopard.web.xparam.XParamUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class StartXParam
implements XParam {
    @Autowired
    private PageIdXParam pageIdXParam;
    @Autowired
    private SizeXParam sizeXParam;

    @Override
    public Object getValue(HttpServletRequest request, MethodParameter parameter) {
        int start;
        String value = request.getParameter("start");
        if (StringUtils.isEmpty((Object)value)) {
            int pageId = (Integer)this.pageIdXParam.getValue(request, parameter);
            int size = (Integer)this.sizeXParam.getValue(request, parameter);
            start = StartXParam.getPageStart(pageId, size);
        } else {
            start = XParamUtil.toInt(request.getParameter("start"));
            if (start <= 0) {
                start = 0;
            }
        }
        return start;
    }

    public static int getPageStart(int pageId, int size) {
        if (pageId < 1) {
            throw new IllegalArgumentException("pageid\u4e0d\u80fd\u5c0f\u4e8e1.");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size\u4e0d\u80fd\u5c0f\u4e8e1.");
        }
        return (pageId - 1) * size;
    }

    @Override
    public String getKey() {
        return "start";
    }
}

