/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam;

import io.leopard.web.xparam.resolver.ModelHandlerMethodArgumentResolver;
import io.leopard.web.xparam.resolver.ParamListHandlerMethodArgumentResolver;
import io.leopard.web.xparam.resolver.PathRegexHandlerMethodArgumentResolver;
import io.leopard.web.xparam.resolver.PrimitiveMethodArgumentResolver;
import io.leopard.web.xparam.resolver.TimeRangeHandlerMethodArgumentResolver;
import io.leopard.web.xparam.resolver.UnderlineHandlerMethodArgumentResolver;
import io.leopard.web.xparam.resolver.XParamHandlerMethodArgumentResolver;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Component
public class XParamBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RequestMappingHandlerAdapter) {
            this.registerHandlerMethodArgumentResolver((RequestMappingHandlerAdapter)bean);
        }
        return bean;
    }

    private void registerHandlerMethodArgumentResolver(RequestMappingHandlerAdapter adapter) {
        ArrayList<AbstractNamedValueMethodArgumentResolver> customArgumentResolvers = adapter.getCustomArgumentResolvers();
        if (customArgumentResolvers == null) {
            customArgumentResolvers = new ArrayList<AbstractNamedValueMethodArgumentResolver>();
            adapter.setCustomArgumentResolvers(customArgumentResolvers);
        }
        Object argumentResolver = (XParamHandlerMethodArgumentResolver)((Object)this.beanFactory.getBean(XParamHandlerMethodArgumentResolver.class));
        customArgumentResolvers.add((AbstractNamedValueMethodArgumentResolver)argumentResolver);
        customArgumentResolvers.add(new PrimitiveMethodArgumentResolver());
        argumentResolver = (PathRegexHandlerMethodArgumentResolver)this.beanFactory.getBean(PathRegexHandlerMethodArgumentResolver.class);
        customArgumentResolvers.add((AbstractNamedValueMethodArgumentResolver)argumentResolver);
        argumentResolver = (ParamListHandlerMethodArgumentResolver)((Object)this.beanFactory.getBean(ParamListHandlerMethodArgumentResolver.class));
        customArgumentResolvers.add((AbstractNamedValueMethodArgumentResolver)argumentResolver);
        argumentResolver = (TimeRangeHandlerMethodArgumentResolver)((Object)this.beanFactory.getBean(TimeRangeHandlerMethodArgumentResolver.class));
        customArgumentResolvers.add((AbstractNamedValueMethodArgumentResolver)argumentResolver);
        if (UnderlineHandlerMethodArgumentResolver.isEnable()) {
            argumentResolver = (UnderlineHandlerMethodArgumentResolver)((Object)this.beanFactory.getBean(UnderlineHandlerMethodArgumentResolver.class));
            customArgumentResolvers.add((AbstractNamedValueMethodArgumentResolver)argumentResolver);
        }
        if (UnderlineHandlerMethodArgumentResolver.isEnable()) {
            argumentResolver = (ModelHandlerMethodArgumentResolver)((Object)this.beanFactory.getBean(ModelHandlerMethodArgumentResolver.class));
            customArgumentResolvers.add((AbstractNamedValueMethodArgumentResolver)argumentResolver);
        }
        customArgumentResolvers.add(new PrimitiveMethodArgumentResolver());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

