/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam;

import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;

public class XParamUtil {
    public static boolean isFalse(String value) {
        return "false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "0".equals(value) || "off".equalsIgnoreCase(value);
    }

    public static boolean isTrue(String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equals(value) || "on".equalsIgnoreCase(value);
    }

    public static int toInt(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getCookie(String name, HttpServletRequest request) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public static String getProxyIp(HttpServletRequest request) {
        String proxyIp = request.getHeader("X-Real-IP");
        if (proxyIp == null) {
            proxyIp = request.getHeader("RealIP");
        }
        if (proxyIp == null) {
            proxyIp = request.getRemoteAddr();
        }
        return proxyIp;
    }

    public static String[] getParameterNames(MethodParameter parameter) {
        Method method = parameter.getMethod();
        LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
        return parameterNameDiscoverer.getParameterNames(method);
    }
}

