/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam.resolver;

import io.leopard.web.xparam.resolver.AbstractNamedValueMethodArgumentResolver;
import io.leopard.web.xparam.resolver.ParamListHandlerMethodArgumentResolver;
import io.leopard.web.xparam.resolver.UnderlineHandlerMethodArgumentResolver;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.NativeWebRequest;

@Component
public class ModelHandlerMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Value(value="${xparam.underline}")
    private String underline;
    private static boolean enable = true;

    @PostConstruct
    public void init() {
        enable = !"false".equals(this.underline);
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        ModelHandlerMethodArgumentResolver.enable = enable;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        if (type.isEnum()) {
            return false;
        }
        String className = type.getName();
        boolean supports = false;
        if (className.endsWith("VO") || className.endsWith("Form")) {
            supports = true;
        }
        if (className.endsWith("AddressVO")) {
            supports = true;
        }
        return supports;
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request.getNativeRequest();
        Class clazz = parameter.getParameterType();
        Object bean = clazz.newInstance();
        for (Field field : clazz.getDeclaredFields()) {
            Object obj;
            String fieldName = field.getName();
            Class<?> type = field.getType();
            if (List.class.equals(type)) {
                Class subType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                obj = this.toList(fieldName, subType, req);
            } else {
                String underlineName = UnderlineHandlerMethodArgumentResolver.camelToUnderline(fieldName);
                String value = req.getParameter(underlineName);
                if (value == null) continue;
                obj = this.toObject(value, type);
            }
            field.setAccessible(true);
            field.set(bean, obj);
        }
        return bean;
    }

    protected Object toList(String fieldName, Class<?> subType, HttpServletRequest req) {
        String underlineName = fieldName.replaceFirst("List$", "");
        underlineName = UnderlineHandlerMethodArgumentResolver.camelToUnderline(underlineName);
        Object[] values = req.getParameterValues(underlineName);
        this.logger.info((Object)("toList fieldName:" + fieldName + " underlineName:" + underlineName + " values:" + StringUtils.join((Object[])values, (String)",   ")));
        if (values == null) {
            return null;
        }
        if (subType.equals(String.class)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object value : values) {
                list.add(value);
            }
            return list;
        }
        if (subType.equals(Integer.class)) {
            throw new NotImplementedException("List<Integer>\u672a\u5b9e\u73b0.");
        }
        if (subType.equals(Long.class)) {
            throw new NotImplementedException("List<Long>\u672a\u5b9e\u73b0.");
        }
        if (subType.equals(Float.class)) {
            throw new NotImplementedException("List<Float>\u672a\u5b9e\u73b0.");
        }
        if (subType.equals(Double.class)) {
            throw new NotImplementedException("List<Double>\u672a\u5b9e\u73b0.");
        }
        if (subType.equals(Boolean.class)) {
            throw new NotImplementedException("List<Boolean>\u672a\u5b9e\u73b0.");
        }
        if (subType.equals(Date.class)) {
            throw new NotImplementedException("List<Date>\u672a\u5b9e\u73b0.");
        }
        return ParamListHandlerMethodArgumentResolver.toList(subType, (String[])values);
    }

    protected Object toObject(String value, Class<?> type) {
        if (String.class.equals(type)) {
            return value;
        }
        if (Boolean.TYPE.equals(type)) {
            return "true".equals(value);
        }
        if (Integer.TYPE.equals(type)) {
            return NumberUtils.toInt((String)value);
        }
        if (Integer.class.equals(type)) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return NumberUtils.toInt((String)value);
        }
        if (Long.TYPE.equals(type)) {
            return NumberUtils.toLong((String)value);
        }
        if (Long.class.equals(type)) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return NumberUtils.toLong((String)value);
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(NumberUtils.toFloat((String)value));
        }
        if (Float.class.equals(type)) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return Float.valueOf(NumberUtils.toFloat((String)value));
        }
        if (Double.TYPE.equals(type)) {
            return NumberUtils.toDouble((String)value);
        }
        if (Double.class.equals(type)) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            return NumberUtils.toDouble((String)value);
        }
        if (Date.class.equals(type)) {
            long time = NumberUtils.toLong((String)value);
            if (time <= 0L) {
                return null;
            }
            return new Date(time);
        }
        return ParamListHandlerMethodArgumentResolver.toObject(value, type);
    }
}

