/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam.resolver;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.leopard.json.Json;
import io.leopard.json.JsonException;
import io.leopard.web.xparam.resolver.AbstractNamedValueMethodArgumentResolver;
import io.leopard.web.xparam.resolver.UnderlineHandlerMethodArgumentResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ParamListHandlerMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    private Set<String> simpleClassSet = new HashSet<String>();
    private Map<Integer, Class<?>> modelMap = new ConcurrentHashMap();
    @Value(value="${xparam.underline}")
    private String underline;
    private static ObjectMapper mapper;

    public ParamListHandlerMethodArgumentResolver() {
        this.simpleClassSet.add(String.class.getName());
        this.simpleClassSet.add(Long.class.getName());
        this.simpleClassSet.add(Float.class.getName());
        this.simpleClassSet.add(Integer.class.getName());
        this.simpleClassSet.add(Double.class.getName());
        this.simpleClassSet.add(Date.class.getName());
        this.simpleClassSet.add(MultipartFile.class.getName());
    }

    @PostConstruct
    public void init() {
        boolean enable = !"false".equals(this.underline);
        mapper = new ObjectMapper();
        if (enable) {
            mapper = mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        if (!type.equals(List.class)) {
            return false;
        }
        String name = parameter.getParameterName();
        boolean support = name.endsWith("List");
        if (!support) {
            return false;
        }
        Type[] args = ((ParameterizedType)parameter.getGenericParameterType()).getActualTypeArguments();
        Class clazz = (Class)args[0];
        boolean isModel = this.isModelClass(clazz);
        if (isModel) {
            this.modelMap.put(parameter.hashCode(), clazz);
            System.err.println("name:" + name + " typeName:" + args[0] + " isModel:" + isModel);
        }
        return support;
    }

    private boolean isModelClass(Class<?> clazz) {
        return !this.simpleClassSet.contains(clazz.getName());
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request.getNativeRequest();
        name = name.replaceFirst("List$", "");
        name = UnderlineHandlerMethodArgumentResolver.camelToUnderline(name);
        String[] values = req.getParameterValues(name);
        int hashCode = parameter.hashCode();
        Class<?> clazz = this.modelMap.get(hashCode);
        if (clazz != null) {
            return ParamListHandlerMethodArgumentResolver.toList(clazz, values);
        }
        if (values != null && values.length == 1) {
            if (StringUtils.isEmpty((Object)values[0])) {
                return null;
            }
            if (values[0].startsWith("[") && values[0].endsWith("]")) {
                return Json.toListObject((String)values[0], String.class);
            }
        }
        return values;
    }

    protected static List toList(Class<?> clazz, String[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            if (StringUtils.isEmpty((Object)values[0])) {
                return null;
            }
            if (values[0].startsWith("[")) {
                return ParamListHandlerMethodArgumentResolver.toListObject(values[0], clazz);
            }
        }
        ArrayList list = new ArrayList();
        for (String value : values) {
            Object bean = ParamListHandlerMethodArgumentResolver.toObject(value, clazz);
            list.add(bean);
        }
        return list;
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        if (json == null || json.length() == 0) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> List<T> toListObject(String json, Class<T> clazz) {
        if (json == null || json.length() == 0) {
            return null;
        }
        JavaType javaType = mapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, new Class[]{clazz});
        try {
            return (List)mapper.readValue(json, javaType);
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }
}

