/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam.resolver;

import io.leopard.web.xparam.resolver.UnderlineHandlerMethodArgumentResolver;
import javax.servlet.ServletException;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;

public class PrimitiveMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        RequestParam ann = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        if (ann != null) {
            return false;
        }
        Class clazz = parameter.getParameterType();
        if (clazz.equals(Long.TYPE)) {
            return true;
        }
        if (clazz.equals(Integer.TYPE)) {
            return true;
        }
        if (clazz.equals(Double.TYPE)) {
            return true;
        }
        return clazz.equals(Float.TYPE);
    }

    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        return new RequestParamNamedValueInfo();
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest webRequest) throws Exception {
        String[] paramValues;
        Object arg = null;
        if (UnderlineHandlerMethodArgumentResolver.isEnable()) {
            name = UnderlineHandlerMethodArgumentResolver.camelToUnderline(name);
        }
        if ((paramValues = webRequest.getParameterValues(name)) != null) {
            Object object = arg = paramValues.length == 1 ? paramValues[0] : paramValues;
        }
        if (arg == null) {
            arg = this.getDefaultValue(parameter);
        }
        return arg;
    }

    protected Object getDefaultValue(MethodParameter parameter) {
        Class clazz = parameter.getParameterType();
        if (clazz.equals(Long.TYPE)) {
            return 0L;
        }
        if (clazz.equals(Integer.TYPE)) {
            return 0;
        }
        if (clazz.equals(Double.TYPE)) {
            return 0.0;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        throw new RuntimeException("\u672a\u77e5\u7c7b\u578b[" + clazz.getName() + "].");
    }

    protected void handleMissingValue(String name, MethodParameter parameter) throws ServletException {
    }

    private static class RequestParamNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        public RequestParamNamedValueInfo() {
            super("", false, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        public RequestParamNamedValueInfo(RequestParam annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

