/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam.resolver;

import io.leopard.burrow.util.DateUtil;
import io.leopard.lang.TimeRange;
import io.leopard.web.xparam.resolver.AbstractNamedValueMethodArgumentResolver;
import io.leopard.web.xparam.resolver.UnderlineHandlerMethodArgumentResolver;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.NativeWebRequest;

@Component
public class TimeRangeHandlerMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static String Timestamp_regex = "1[0-9]{12}";
    private static String DATE_regex = "^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}$";

    public boolean supportsParameter(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return type.equals(TimeRange.class);
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request.getNativeRequest();
        String startTime = UnderlineHandlerMethodArgumentResolver.getParameter(req, "startTime");
        String endTime = UnderlineHandlerMethodArgumentResolver.getParameter(req, "endTime");
        TimeRange range = new TimeRange();
        if (StringUtils.isNotEmpty((String)startTime)) {
            range.setStartTime(TimeRangeHandlerMethodArgumentResolver.toDate(startTime));
        }
        if (StringUtils.isNotEmpty((String)endTime)) {
            range.setEndTime(TimeRangeHandlerMethodArgumentResolver.toDate(endTime));
        }
        return range;
    }

    protected static Date toDate(String datetime) {
        if (datetime.matches(Timestamp_regex)) {
            long time = Long.parseLong(datetime);
            return new Date(time);
        }
        if (datetime.matches(DATE_regex)) {
            datetime = datetime + " 00:00:00";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                return DateUtil.toDate((String)datetime);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return DateUtil.toDate((String)datetime);
    }
}

