/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam.resolver;

import io.leopard.web.xparam.resolver.AbstractNamedValueMethodArgumentResolver;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.NativeWebRequest;

@Component
public class UnderlineHandlerMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    @Value(value="${xparam.underline}")
    private String underline;
    private static boolean enable = true;

    @PostConstruct
    public void init() {
        enable = !"false".equals(this.underline);
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        UnderlineHandlerMethodArgumentResolver.enable = enable;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        String name = parameter.getParameterName();
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        boolean supports = false;
        for (char ch : name.toCharArray()) {
            if (!Character.isUpperCase(ch)) continue;
            supports = true;
            break;
        }
        return supports;
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request.getNativeRequest();
        String underlineName = UnderlineHandlerMethodArgumentResolver.camelToUnderline(name);
        String value = req.getParameter(underlineName);
        return value;
    }

    public static String getParameter(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        if (enable && value == null) {
            value = request.getParameter(UnderlineHandlerMethodArgumentResolver.camelToUnderline(name));
        }
        return value;
    }

    public static String camelToUnderline(String param) {
        if (param == null || param.length() == 0) {
            return param;
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

