/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.xparam.resolver;

import io.leopard.web.xparam.XParam;
import io.leopard.web.xparam.api.UserinfoResolverImpl;
import io.leopard.web.xparam.resolver.AbstractNamedValueMethodArgumentResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.NativeWebRequest;

@Component
public class XParamHandlerMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver
implements BeanFactoryAware {
    private static final Map<String, List<XParam>> data = new HashMap<String, List<XParam>>();
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        UserinfoResolverImpl.setBeanFactory(beanFactory);
        ListableBeanFactory factory = (ListableBeanFactory)beanFactory;
        Map map = factory.getBeansOfType(XParam.class);
        for (Map.Entry entry : map.entrySet()) {
            XParam xparam = (XParam)entry.getValue();
            List<XParam> xparamList = data.get(xparam.getKey());
            if (xparamList == null) {
                xparamList = new ArrayList<XParam>();
                data.put(xparam.getKey(), xparamList);
            }
            xparamList.add(xparam);
        }
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            List xparamList = (List)entry.getValue();
            if (xparamList.size() <= 1) continue;
            AnnotationAwareOrderComparator.sort((List)xparamList);
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        String name = parameter.getParameterName();
        boolean isSpecialName = data.containsKey(name);
        return isSpecialName;
    }

    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        XParam xparam;
        List<XParam> xparamList = data.get(name);
        if (xparamList == null) {
            throw new IllegalArgumentException("\u672a\u77e5\u53c2\u6570\u540d\u79f0[" + name + "].");
        }
        Object value = null;
        Iterator<XParam> iterator = xparamList.iterator();
        while (iterator.hasNext() && (value = (xparam = iterator.next()).getValue((HttpServletRequest)request.getNativeRequest(), parameter)) == null) {
        }
        return value;
    }
}

