/*
 * Decompiled with CFR 0.152.
 */
package liberalize.java.backend.sdk.data.network;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import liberalize.java.backend.sdk.LiberalizeBE;
import liberalize.java.backend.sdk.data.model.ErrorResponse;
import liberalize.java.backend.sdk.data.network.ApiResponse;
import liberalize.java.backend.sdk.data.network.Authorization;
import liberalize.java.backend.sdk.data.network.Environment;
import liberalize.java.backend.sdk.data.network.HttpClient;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class HttpClientImpl
implements HttpClient {
    private final Authorization authorization;
    private OkHttpClient client;
    private final Gson gson = new Gson();

    public HttpClientImpl(Authorization authorization) {
        this.authorization = authorization;
        this.setTimeOut();
    }

    private void setTimeOut() {
        this.client = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
    }

    @Override
    public void post(String path, Headers headers, RequestBody body, ApiResponse apiResponse) {
        Request request = this.createRequest("POST", path, headers, body);
        this.call(request, apiResponse);
    }

    @Override
    public void get(String path, Headers headers, ApiResponse apiResponse) {
        Request request = this.createRequest("GET", path, headers, null);
        this.call(request, apiResponse);
    }

    @Override
    public void put(String path, Headers headers, RequestBody body, ApiResponse apiResponse) {
        Request request = this.createRequest("PUT", path, headers, body);
        this.call(request, apiResponse);
    }

    private void call(Request request, final ApiResponse apiResponse) {
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                apiResponse.onError("No internet connection");
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                HttpClientImpl.this.handleResponse(response, apiResponse);
            }
        });
    }

    private void handleResponse(@NotNull Response response, @NotNull ApiResponse apiResponse) {
        if (response.isSuccessful()) {
            if (response.body() == null) {
                apiResponse.onSuccess("");
            } else {
                try {
                    apiResponse.onSuccess(response.body().string());
                }
                catch (IOException e) {
                    apiResponse.onError("Unknown error");
                }
            }
        } else if (response.body() == null) {
            apiResponse.onError("Unknown error");
        } else {
            try {
                ErrorResponse errorResponse = (ErrorResponse)this.gson.fromJson(response.body().string(), ErrorResponse.class);
                apiResponse.onError(errorResponse.message);
            }
            catch (Exception e) {
                apiResponse.onError(this.getErrorMessage(e));
            }
        }
    }

    private String getErrorMessage(Exception e) {
        if (e instanceof SocketTimeoutException) {
            return "Oops! Technical issue";
        }
        return "Unknown error";
    }

    private Request createRequest(String method, String path, Headers headers, RequestBody body) {
        return new Request.Builder().url(this.getBaseUrl() + path).headers(headers).addHeader("Authorization", "Basic " + this.authorization.value()).method(method, body).build();
    }

    private String getBaseUrl() {
        Environment env = LiberalizeBE.getInstance().getEnv();
        switch (env) {
            case PRODUCTION: {
                return "https://payment.api.liberalize.io";
            }
            case STAGING: {
                return "https://payment.api.staging.liberalize.io";
            }
        }
        return "https://payment.api.dev.liberalize.io";
    }
}

