/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.dropwizard.bundle.graphql;

import com.codahale.metrics.MetricRegistry;
import com.smoketurner.dropwizard.graphql.GraphQLBundle;
import com.smoketurner.dropwizard.graphql.GraphQLFactory;
import graphql.schema.idl.RuntimeWiring;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.setup.Bootstrap;
import io.liftwizard.dropwizard.configuration.graphql.GraphQLFactoryProvider;
import io.liftwizard.graphql.instrumentation.logging.LiftwizardGraphQLLoggingInstrumentation;
import io.liftwizard.graphql.instrumentation.metrics.LiftwizardGraphQLMetricsInstrumentation;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.slf4j.MDC;

public class LiftwizardGraphQLBundle<T extends Configuration>
extends GraphQLBundle<T> {
    @Nonnull
    private final Consumer<RuntimeWiring.Builder> runtimeWiringBuilder;
    private MetricRegistry metricRegistry;

    public LiftwizardGraphQLBundle(@Nonnull Consumer<RuntimeWiring.Builder> runtimeWiringBuilder) {
        this.runtimeWiringBuilder = Objects.requireNonNull(runtimeWiringBuilder);
    }

    public void initialize(@Nonnull Bootstrap<?> bootstrap) {
        try (MDC.MDCCloseable mdc = MDC.putCloseable((String)"liftwizard.bundle", (String)((Object)((Object)this)).getClass().getSimpleName());){
            this.initializeWithMdc(bootstrap);
        }
        this.metricRegistry = bootstrap.getMetricRegistry();
    }

    private void initializeWithMdc(@Nonnull Bootstrap<?> bootstrap) {
        bootstrap.addBundle((ConfiguredBundle)new AssetsBundle("/graphiql", "/graphiql", "index.htm", "graphiql"));
        bootstrap.addBundle((ConfiguredBundle)new AssetsBundle("/assets", "/graphql-playground", "index.htm", "graphql-playground"));
    }

    @Nonnull
    public GraphQLFactory getGraphQLFactory(@Nonnull T configuration) {
        GraphQLFactory factory = ((GraphQLFactoryProvider)configuration).getGraphQLFactory();
        Clock clock = Clock.systemUTC();
        LiftwizardGraphQLMetricsInstrumentation metricsInstrumentation = new LiftwizardGraphQLMetricsInstrumentation(this.metricRegistry, clock);
        LiftwizardGraphQLLoggingInstrumentation loggingInstrumentation = new LiftwizardGraphQLLoggingInstrumentation();
        List<LiftwizardGraphQLLoggingInstrumentation> instrumentations = List.of(metricsInstrumentation, loggingInstrumentation);
        factory.setInstrumentations(instrumentations);
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        this.runtimeWiringBuilder.accept(builder);
        RuntimeWiring runtimeWiring = builder.build();
        factory.setRuntimeWiring(runtimeWiring);
        return factory;
    }
}

