/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.dropwizard.configuration.clock.fixed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.service.AutoService;
import io.dropwizard.validation.ValidationMethod;
import io.liftwizard.dropwizard.configuration.clock.ClockFactory;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="fixed")
@AutoService(value={ClockFactory.class})
public class FixedClockFactory
implements ClockFactory {
    @Valid
    @NotNull
    private Instant instant = Instant.parse("2000-12-31T23:59:59Z");
    @Valid
    @NotNull
    private String timeZoneName = "UTC";

    @Nonnull
    public Clock createClock() {
        ZoneId zoneId = ZoneId.of(this.timeZoneName);
        return Clock.fixed(this.instant, zoneId);
    }

    @JsonProperty
    public Instant getInstant() {
        return this.instant;
    }

    @JsonProperty
    public void setInstant(Instant instant) {
        this.instant = instant;
    }

    @JsonProperty(value="timeZone")
    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    @JsonProperty(value="timeZone")
    public void setTimeZoneName(String timeZoneName) {
        this.timeZoneName = timeZoneName;
    }

    @ValidationMethod(message="Invalid timeZoneName")
    @JsonIgnore
    public boolean isValidTimezone() {
        TimeZone zoneInfo = TimeZone.getTimeZone(this.timeZoneName);
        if (zoneInfo == null) {
            String message = String.format("Got timeZoneName '%s' but expected one of: %s", this.timeZoneName, Arrays.toString(TimeZone.getAvailableIDs()));
            throw new IllegalStateException(message);
        }
        return zoneInfo != null;
    }
}

