/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.dropwizard.configuration.datasource;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.validation.ValidationMethod;
import io.liftwizard.dropwizard.db.NamedDataSourceFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class NamedDataSourcesFactory {
    @Valid
    @NotNull
    private List<NamedDataSourceFactory> namedDataSourceFactories = new ArrayList<NamedDataSourceFactory>();
    private Map<String, NamedDataSourceFactory> namedDataSourceFactoriesByName = new LinkedHashMap<String, NamedDataSourceFactory>();
    private final Map<String, ManagedDataSource> dataSourcesByName = new LinkedHashMap<String, ManagedDataSource>();

    @JsonProperty(value="dataSources")
    public List<NamedDataSourceFactory> getNamedDataSourceFactories() {
        return this.namedDataSourceFactories;
    }

    @JsonProperty(value="dataSources")
    public void setNamedDataSourceFactories(List<NamedDataSourceFactory> namedDataSourceFactories) {
        this.namedDataSourceFactories = namedDataSourceFactories;
        this.namedDataSourceFactoriesByName = new LinkedHashMap<String, NamedDataSourceFactory>();
        for (NamedDataSourceFactory namedDataSourceFactory : namedDataSourceFactories) {
            this.namedDataSourceFactoriesByName.put(namedDataSourceFactory.getName(), namedDataSourceFactory);
        }
    }

    @ValidationMethod
    @JsonIgnore
    public boolean isValidDataSourceNames() {
        List orderedDataSourceNames = this.namedDataSourceFactories.stream().map(NamedDataSourceFactory::getName).collect(Collectors.toList());
        Map frequencies = orderedDataSourceNames.stream().collect(Collectors.groupingBy(Function.identity(), LinkedHashMap::new, Collectors.counting()));
        List duplicateDataSourceNames = frequencies.entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (duplicateDataSourceNames.isEmpty()) {
            return true;
        }
        String errorMessage = "Duplicate names found in dataSources: " + duplicateDataSourceNames;
        throw new IllegalStateException(errorMessage);
    }

    @Nonnull
    @JsonIgnore
    public NamedDataSourceFactory getNamedDataSourceFactoryByName(String name) {
        return this.namedDataSourceFactories.stream().filter(namedDataSourceFactory -> namedDataSourceFactory.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalStateException("Unknown data source name: " + name));
    }

    @JsonIgnore
    public ManagedDataSource getDataSourceByName(@Nonnull String name, @Nonnull MetricRegistry metricRegistry, @Nonnull LifecycleEnvironment lifecycle) {
        if (this.dataSourcesByName.containsKey(name)) {
            return this.dataSourcesByName.get(name);
        }
        if (!this.namedDataSourceFactoriesByName.containsKey(name)) {
            String message = "No data source named: '%s'. Known data sources: %s".formatted(name, this.namedDataSourceFactoriesByName.keySet());
            throw new IllegalStateException(message);
        }
        NamedDataSourceFactory namedDataSourceFactory = this.namedDataSourceFactoriesByName.get(name);
        ManagedDataSource managedDataSource = namedDataSourceFactory.build(metricRegistry);
        lifecycle.manage((Managed)managedDataSource);
        this.dataSourcesByName.put(name, managedDataSource);
        return managedDataSource;
    }
}

