/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.dropwizard.configuration.executor;

import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.service.AutoService;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import io.liftwizard.dropwizard.configuration.executor.ScheduledExecutorServiceFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="default")
@AutoService(value={ScheduledExecutorServiceFactory.class})
public class DefaultScheduledExecutorServiceFactory
implements ScheduledExecutorServiceFactory {
    @Valid
    @NotNull
    private String nameFormat;
    private boolean useDaemonThreads = true;
    @Min(value=0L)
    private @Min(value=0L) int threads = 1;
    @NotNull
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    private @NotNull @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration shutdownTime = Duration.seconds((long)5L);
    private boolean removeOnCancelPolicy;

    @Override
    @JsonIgnore
    public ScheduledExecutorService build(Environment environment) {
        return this.build(environment.lifecycle(), environment.metrics());
    }

    @Override
    @JsonIgnore
    public ScheduledExecutorService build(LifecycleEnvironment environment, MetricRegistry metricRegistry) {
        ScheduledExecutorService scheduledExecutorService = environment.scheduledExecutorService(this.nameFormat, this.useDaemonThreads).threads(this.threads).shutdownTime(this.shutdownTime).removeOnCancelPolicy(this.removeOnCancelPolicy).build();
        return new InstrumentedScheduledExecutorService(scheduledExecutorService, metricRegistry, this.nameFormat);
    }

    @JsonProperty
    public String getNameFormat() {
        return this.nameFormat;
    }

    @JsonProperty
    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    @JsonProperty
    public boolean isUseDaemonThreads() {
        return this.useDaemonThreads;
    }

    @JsonProperty
    public void setUseDaemonThreads(boolean useDaemonThreads) {
        this.useDaemonThreads = useDaemonThreads;
    }

    @JsonProperty
    public int getThreads() {
        return this.threads;
    }

    @JsonProperty
    public void setThreads(int threads) {
        this.threads = threads;
    }

    @JsonProperty
    public Duration getShutdownTime() {
        return this.shutdownTime;
    }

    @JsonProperty
    public void setShutdownTime(Duration shutdownTime) {
        this.shutdownTime = shutdownTime;
    }

    @JsonProperty
    public boolean isRemoveOnCancelPolicy() {
        return this.removeOnCancelPolicy;
    }

    @JsonProperty
    public void setRemoveOnCancelPolicy(boolean removeOnCancelPolicy) {
        this.removeOnCancelPolicy = removeOnCancelPolicy;
    }
}

