/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.dropwizard.configuration.executor;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.ValidationMethod;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class ExecutorServiceFactory {
    @Valid
    @NotNull
    private String nameFormat;
    @Min(value=0L)
    private @Min(value=0L) int minThreads;
    @Min(value=1L)
    private @Min(value=1L) int maxThreads = 1;
    private boolean allowCoreThreadTimeOut;
    @NotNull
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    private @NotNull @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration keepAliveTime = Duration.seconds((long)60L);
    @NotNull
    @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false)
    private @NotNull @MinDuration(value=0L, unit=TimeUnit.MILLISECONDS, inclusive=false) Duration shutdownTime = Duration.seconds((long)5L);

    @ValidationMethod(message="maxThreads < minThreads")
    @JsonIgnore
    public boolean isValidPoolSize() {
        return this.minThreads <= this.maxThreads;
    }

    @JsonIgnore
    public ExecutorService build(Environment environment) {
        return this.build(environment.lifecycle(), environment.metrics());
    }

    @JsonIgnore
    public ExecutorService build(LifecycleEnvironment environment, MetricRegistry metricRegistry) {
        ExecutorService executorService = environment.executorService(this.nameFormat).minThreads(this.minThreads).maxThreads(this.maxThreads).allowCoreThreadTimeOut(this.allowCoreThreadTimeOut).keepAliveTime(this.keepAliveTime).shutdownTime(this.shutdownTime).build();
        return new InstrumentedExecutorService(executorService, metricRegistry, this.nameFormat);
    }

    @JsonProperty
    public String getNameFormat() {
        return this.nameFormat;
    }

    @JsonProperty
    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    @JsonProperty
    public int getMinThreads() {
        return this.minThreads;
    }

    @JsonProperty
    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    @JsonProperty
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @JsonProperty
    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @JsonProperty
    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    @JsonProperty
    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    @JsonProperty
    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @JsonProperty
    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    @JsonProperty
    public Duration getShutdownTime() {
        return this.shutdownTime;
    }

    @JsonProperty
    public void setShutdownTime(Duration shutdownTime) {
        this.shutdownTime = shutdownTime;
    }
}

