/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.dropwizard.configuration.executor;

import io.liftwizard.dropwizard.configuration.executor.AbstractDelegatingScheduledExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoopScheduledExecutorService
extends AbstractDelegatingScheduledExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoopScheduledExecutorService.class);

    public NoopScheduledExecutorService(ScheduledExecutorService delegate) {
        super(delegate);
    }

    @Override
    protected Runnable wrapTask(Runnable runnable) {
        return () -> LOGGER.debug("Skip scheduled runnable: {}", (Object)runnable);
    }

    @Override
    protected <V> Callable<V> wrapTask(Callable<V> callable) {
        return () -> {
            LOGGER.debug("Skip scheduled callable: {}", (Object)callable);
            return null;
        };
    }
}

