/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.dropwizard.configuration.executor;

import com.codahale.metrics.InstrumentedScheduledExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.auto.service.AutoService;
import io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import io.dropwizard.setup.Environment;
import io.liftwizard.dropwizard.configuration.executor.NoopScheduledExecutorService;
import io.liftwizard.dropwizard.configuration.executor.ScheduledExecutorServiceFactory;
import java.util.concurrent.ScheduledExecutorService;

@JsonTypeName(value="noop")
@AutoService(value={ScheduledExecutorServiceFactory.class})
public class NoopScheduledExecutorServiceFactory
implements ScheduledExecutorServiceFactory {
    @Override
    @JsonIgnore
    public ScheduledExecutorService build(Environment environment) {
        return this.build(environment.lifecycle(), environment.metrics());
    }

    @Override
    @JsonIgnore
    public ScheduledExecutorService build(LifecycleEnvironment environment, MetricRegistry metricRegistry) {
        ScheduledExecutorService scheduledExecutorService = environment.scheduledExecutorService("noop", true).build();
        NoopScheduledExecutorService noopScheduledExecutorService = new NoopScheduledExecutorService(scheduledExecutorService);
        return new InstrumentedScheduledExecutorService((ScheduledExecutorService)noopScheduledExecutorService, metricRegistry, "noop");
    }
}

