/*
 * Decompiled with CFR 0.152.
 */
package io.liftwizard.junit.rule.log.marker;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class LogMarkerTestRule
extends TestWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMarkerTestRule.class);
    private static final Marker MARKER_CLEAR = MarkerFactory.getMarker((String)"CLEAR");
    private static final Marker MARKER_FLUSH = MarkerFactory.getMarker((String)"FLUSH");

    protected void starting(Description description) {
        MDC.put((String)"liftwizard.junit.test.name", (String)description.getDisplayName());
        LOGGER.info(MARKER_CLEAR, "Test starting. Logging the CLEAR marker to clear the buffer in BufferedAppender.");
    }

    protected void failed(Throwable e, Description description) {
        LOGGER.info(MARKER_FLUSH, "Test failed. Logging the FLUSH marker to flush the buffer in BufferedAppender.");
    }

    protected void finished(Description description) {
        MDC.remove((String)"liftwizard.junit.test.name");
    }
}

