/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.autostop;

import io.lightlink.core.RunnerContext;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoStopQuery {
    public static final Logger LOG = LoggerFactory.getLogger(AutoStopQuery.class);
    public static final int PING_INTERVAL = 300;
    private Timer timer = new Timer("Timer of " + AutoStopQuery.class.getName());
    private Set<Record> records = new HashSet<Record>();
    private static AutoStopQuery ourInstance = new AutoStopQuery();

    public static AutoStopQuery getInstance() {
        return ourInstance;
    }

    private AutoStopQuery() {
    }

    public synchronized void register(RunnerContext runnerContext, PreparedStatement ps) {
        Record record = new Record(runnerContext, ps);
        this.records.add(record);
    }

    public void cancelQuery(Record record) {
        Statement statement = record.getStatement();
        if (statement != null) {
            try {
                this.unregister(record);
                statement.cancel();
            }
            catch (SQLException e) {
                LOG.debug(e.toString(), (Throwable)e);
            }
        }
    }

    public int cancelAllForWindow(String csrfToken) {
        Record[] array;
        int counter = 0;
        for (Record record : array = this.records.toArray(new Record[0])) {
            RunnerContext runnerContext = record.getRunnerContext();
            if (runnerContext == null || runnerContext.getCsrfToken() == null || !runnerContext.getCsrfToken().equals(csrfToken)) continue;
            this.cancelQuery(record);
            ++counter;
        }
        return counter;
    }

    private synchronized void unregister(Record record) {
        this.records.remove(record);
    }

    public synchronized void unregister(RunnerContext runnerContext, PreparedStatement ps) {
        this.records.remove(new Record(runnerContext, ps));
    }

    class Record {
        private WeakReference<RunnerContext> runnerContext;
        private WeakReference<Statement> statement;
        private boolean active;

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        Record(RunnerContext runnerContext, Statement statement) {
            this.runnerContext = new WeakReference<RunnerContext>(runnerContext);
            this.statement = new WeakReference<Statement>(statement);
        }

        public RunnerContext getRunnerContext() {
            return (RunnerContext)this.runnerContext.get();
        }

        public Statement getStatement() {
            return (Statement)this.statement.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return this.statement.get() == record.statement.get();
        }

        public int hashCode() {
            return this.statement.get() != null ? System.identityHashCode(this.statement.get()) : 0;
        }
    }
}

