/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.config;

import io.lightlink.config.Script;
import io.lightlink.exception.ActionNotFoundException;
import io.lightlink.translator.ScriptTranslator;
import io.lightlink.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.ServletContext;

public class ConfigManager {
    public static final String DEFAULT_ROOT_PACKAGE = "lightlink";
    private ServletContext servletContext;
    private String rootPackage;
    private ScriptTranslator translator = new ScriptTranslator();

    public ConfigManager() {
        this(DEFAULT_ROOT_PACKAGE);
    }

    public ConfigManager(String rootPackage) {
        this.rootPackage = rootPackage.replace('.', '/');
    }

    public ConfigManager(String rootPackage, ServletContext servletContext) {
        this(rootPackage);
        this.servletContext = servletContext;
    }

    public ConfigManager(ServletContext servletContext) {
        this();
        this.servletContext = servletContext;
    }

    public static ScriptEngine getScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        if (engine == null) {
            throw new IllegalStateException("Nashorn engine is not found. Please make sure you use Java 8 or higher OR to run on Java7 you need to add Nashorn backport jar to your webapp");
        }
        return engine;
    }

    public String getRootPackage() {
        return this.rootPackage;
    }

    public static boolean isInDebugMode() {
        return "true".equalsIgnoreCase(System.getProperty("lightlink.debug"));
    }

    public List<Script> getConfigAndContent(String actionName, String method) {
        Script mainScriptPostprocess;
        Script mainScriptSql;
        Script mainScript;
        ArrayList<Script> res = new ArrayList<Script>();
        boolean methodPresent = !Utils.isBlank(method);
        int pos = 0;
        do {
            Script scriptSql;
            String dir;
            Script script;
            if ((script = this.getScript((dir = actionName.substring(0, pos)) + "/config.js", false)) != null) {
                res.add(script);
            }
            if (methodPresent && (script = this.getScript(dir + "/config." + method + ".js", false)) != null) {
                res.add(script);
            }
            if ((scriptSql = this.getScript(dir + "/config.js.sql", true)) != null) {
                res.add(scriptSql);
            }
            if (!methodPresent || (scriptSql = this.getScript(dir + "/config." + method + ".js.sql", true)) == null) continue;
            res.add(scriptSql);
        } while (-1 != (pos = actionName.indexOf("/", pos + 1)));
        Script script = mainScript = methodPresent ? this.getScript(actionName + "." + method + ".js", false) : null;
        if (mainScript == null) {
            mainScript = this.getScript(actionName + ".js", false);
        }
        Script script2 = mainScriptSql = methodPresent ? this.getScript(actionName + "." + method + ".js.sql", true) : null;
        if (mainScriptSql == null) {
            mainScriptSql = this.getScript(actionName + ".js.sql", true);
        }
        Script script3 = mainScriptPostprocess = methodPresent ? this.getScript(actionName + "." + method + ".postprocess.js", false) : null;
        if (mainScriptPostprocess == null) {
            mainScriptPostprocess = this.getScript(actionName + ".postprocess.js", false);
        }
        if (mainScript == null && mainScriptSql == null) {
            throw new ActionNotFoundException(actionName);
        }
        if (mainScript != null) {
            res.add(mainScript);
        }
        if (mainScriptSql != null) {
            res.add(mainScriptSql);
        }
        if (mainScriptPostprocess != null) {
            res.add(mainScriptPostprocess);
        }
        return res;
    }

    public Script getScript(String scriptName, boolean translationNeeded) {
        String name;
        URL url;
        if ((scriptName = scriptName.replace('\\', '/')).startsWith("/")) {
            scriptName = scriptName.substring(1);
        }
        if ((url = Utils.getUrl(name = this.getRootPackage() + "/" + scriptName, this.servletContext)) == null) {
            return null;
        }
        try {
            String content = this.getScriptContent(url, scriptName, translationNeeded);
            return new Script(scriptName, url, content);
        }
        catch (IOException e) {
            return null;
        }
    }

    private String getScriptContent(URL url, String scriptName, boolean translationNeeded) throws IOException {
        InputStream stream = url.openStream();
        String content = Utils.streamToString(stream);
        stream.close();
        content = this.processInclude(scriptName, content, translationNeeded);
        if (translationNeeded) {
            content = this.translator.translate(scriptName, url, content);
        }
        return content;
    }

    private boolean prefixedByComment(int pos, StringBuilder sb) {
        if (pos < 2) {
            return false;
        }
        char a = sb.charAt(pos - 1);
        char b = sb.charAt(pos - 2);
        return a == '/' && b == '/' || a == '-' || b == '-';
    }

    private String processInclude(String scriptName, String content, boolean translationNeeded) {
        String key = "@include ";
        if (content.contains(key)) {
            StringBuilder sb = new StringBuilder(content);
            int pos = -1;
            block0: while (-1 != (pos = sb.indexOf(key, pos + 1))) {
                if (!this.prefixedByComment(pos, sb)) continue;
                int keyLength = key.length() + 2;
                boolean inclAsTemplate = sb.charAt(pos -= 2) == '-';
                for (int pos2 = pos + keyLength; pos2 < sb.length(); ++pos2) {
                    char c = sb.charAt(pos2);
                    if (!Character.isWhitespace(c) && pos2 != sb.length() - 1) continue;
                    if (pos2 == sb.length() - 1) {
                        ++pos2;
                    }
                    String resource = sb.substring(pos + keyLength, pos2);
                    sb.delete(pos, pos2);
                    int lastSlash = scriptName.lastIndexOf("/");
                    if (lastSlash == -1) {
                        lastSlash = 0;
                    }
                    String scriptDir = scriptName.substring(0, lastSlash);
                    String path = "/" + scriptDir + "/" + resource;
                    Script script = this.getScript(path, false);
                    if (script == null) {
                        throw new IllegalArgumentException("Cannot include '" + resource + "' from '" + scriptName + "' File:'" + path + "' not found");
                    }
                    String prefix = "";
                    String postfix = "";
                    if (path.endsWith(".js.sql") && !inclAsTemplate) {
                        prefix = "\n%>";
                        postfix = "\n<%";
                    } else if (!path.endsWith(".js.sql") && inclAsTemplate) {
                        prefix = "\n<%";
                        postfix = "\n%>";
                    }
                    sb.insert(pos, prefix + script.getContent() + postfix);
                    continue block0;
                }
            }
            return sb.toString();
        }
        return content;
    }
}

