/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.core;

import javax.servlet.http.HttpServletRequest;

public class Hints {
    private boolean autoDetectDroppedClient;
    private int[] progressive;
    private boolean antiXSS;

    private Hints() {
    }

    public boolean isAutoDetectDroppedClient() {
        return this.autoDetectDroppedClient;
    }

    public int[] getProgressiveBlockSizes() {
        return this.progressive;
    }

    public static Hints fromRequest(HttpServletRequest servletRequest) {
        String antiXSS;
        String autoDetectDroppedClient;
        Hints hints = new Hints();
        String progressive = servletRequest.getHeader("lightlink-progressive");
        if (progressive != null && progressive.trim().length() > 0) {
            if (progressive.equalsIgnoreCase("true")) {
                hints.progressive = new int[]{100, 1000};
            } else if (progressive.equalsIgnoreCase("false")) {
                hints.progressive = null;
            } else {
                String[] values = progressive.split(",");
                hints.progressive = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    hints.progressive[i] = Integer.parseInt(values[i].trim());
                }
            }
        }
        if ((autoDetectDroppedClient = servletRequest.getHeader("lightlink-auto-detect-dropped-client")) != null && autoDetectDroppedClient.equalsIgnoreCase("false")) {
            hints.autoDetectDroppedClient = false;
        }
        if ((antiXSS = servletRequest.getHeader("lightlink-anti-xss")) != null && antiXSS.equalsIgnoreCase("false")) {
            hints.antiXSS = false;
        }
        return hints;
    }

    public boolean isAntiXSS() {
        return this.antiXSS;
    }
}

