/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.core;

import io.lightlink.facades.ResponseFacade;
import io.lightlink.facades.SQLFacade;
import io.lightlink.facades.TxFacade;
import io.lightlink.facades.TypesFacade;
import io.lightlink.output.ResponseStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.JSObject;

public class RunnerContext {
    private CompiledScript newObjectScript;
    private TxFacade txFacade;
    private TypesFacade typesFacade;
    private ResponseFacade responseFacade;
    private ScriptEngine scriptEngine;
    private Set<String> usedResultSetNames = new HashSet<String>();
    private ResponseStream responseStream;
    private String csrfToken;
    private SQLFacade SQLFacade;
    private SQLFacade rootSQLFacade;

    public RunnerContext(ResponseStream responseStream, ScriptEngine scriptEngine) {
        this.responseStream = responseStream;
        responseStream.setRunnerContext(this);
        this.scriptEngine = scriptEngine;
        this.txFacade = new TxFacade(this);
        this.typesFacade = new TypesFacade(this);
        this.responseFacade = new ResponseFacade(this);
        this.initializeScriptingObjects((Compilable)((Object)scriptEngine));
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }

    public void setCsrfToken(String csrfToken) {
        this.csrfToken = csrfToken;
    }

    protected void initializeScriptingObjects(Compilable scriptEngine) {
        try {
            this.newObjectScript = scriptEngine.compile("({})");
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public ResponseFacade getResponseFacade() {
        return this.responseFacade;
    }

    public TxFacade getTxFacade() {
        return this.txFacade;
    }

    public TypesFacade getTypesFacade() {
        return this.typesFacade;
    }

    public ScriptContext getScriptContext() {
        return this.scriptEngine.getContext();
    }

    public ResponseStream getResponseStream() {
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream resp) {
        this.responseStream = resp;
        resp.setRunnerContext(this);
    }

    private ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public JSObject newJSObject() {
        try {
            return (JSObject)this.newObjectScript.eval();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public Set<String> getUsedResultSetNames() {
        return this.usedResultSetNames;
    }

    public void clearParams() throws ScriptException {
        this.getScriptEngine().eval("$P = {}");
    }

    public Object getParam(String name) throws ScriptException {
        Object res = this.getScriptEngine().eval("$P['__" + name + "']");
        if (res instanceof CharSequence && !(res instanceof String)) {
            res = res.toString();
        }
        return res;
    }

    public void setParams(Map<String, Object> inputParams) {
        try {
            JSObject params = this.mapToJSObject(inputParams);
            this.getScriptContext().setAttribute("p", params, 100);
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public JSObject mapToJSObject(Map<String, Object> inputParams) throws ScriptException {
        JSObject params = (JSObject)this.newObjectScript.eval();
        for (Map.Entry<String, Object> entry : inputParams.entrySet()) {
            params.setMember(entry.getKey(), entry.getValue());
        }
        return params;
    }

    public Object getBufferAsJSObject(String buffer) throws ScriptException {
        return this.getScriptEngine().eval("(" + buffer + ").buffer");
    }

    public String getAndClearSQLBuffer() throws SQLException, IOException, ScriptException {
        ScriptContext jsContext = this.getScriptContext();
        Object sqlVarValue = jsContext.getAttribute("$SQL");
        String sql = sqlVarValue == null ? null : sqlVarValue.toString();
        jsContext.setAttribute("$SQL", "", 100);
        return sql;
    }

    public SQLFacade getRootSQLFacade() {
        if (this.rootSQLFacade == null) {
            this.rootSQLFacade = new SQLFacade(this);
        }
        return this.rootSQLFacade;
    }
}

