/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.core;

import io.lightlink.config.ConfigManager;
import io.lightlink.config.Script;
import io.lightlink.core.RunnerContext;
import io.lightlink.facades.ResponseFacade;
import io.lightlink.facades.SQLFacade;
import io.lightlink.facades.ServletEnv;
import io.lightlink.facades.TxFacade;
import io.lightlink.output.ResponseStream;
import io.lightlink.security.CSRFTokensContainer;
import io.lightlink.utils.LogUtils;
import io.lightlink.utils.Utils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.api.scripting.JSObject;

public class ScriptRunner {
    HttpServletResponse response;
    ConfigManager cm;
    HttpServletRequest request;
    private ServletContext servletContext;

    public ScriptRunner(String rootPackage) {
        this.cm = new ConfigManager(rootPackage);
    }

    public ScriptRunner() {
        this.cm = new ConfigManager();
    }

    public ScriptRunner(HttpServletRequest request) {
        this.servletContext = request.getServletContext();
        this.cm = new ConfigManager(this.servletContext);
        this.request = request;
    }

    public ScriptRunner(String rootPackage, HttpServletRequest request, HttpServletResponse resp) {
        this.servletContext = request.getServletContext();
        this.cm = new ConfigManager(rootPackage, this.servletContext);
        this.request = request;
        this.response = resp;
    }

    public ScriptRunner(String rootPackage, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.cm = new ConfigManager(rootPackage, servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String action, String method, Map<String, Object> inputParams, ResponseStream responseStream) throws IOException {
        ScriptEngine engine = ConfigManager.getScriptEngine();
        ScriptContext context = engine.getContext();
        RunnerContext runnerContext = new RunnerContext(responseStream, engine);
        runnerContext.setCsrfToken(CSRFTokensContainer.getToken(inputParams));
        ResponseFacade responseFacade = runnerContext.getResponseFacade();
        SQLFacade sqlFacade = runnerContext.getRootSQLFacade();
        TxFacade txFacade = runnerContext.getTxFacade();
        Bindings bindings = engine.getBindings(100);
        bindings.put("response", (Object)responseFacade);
        bindings.put("env", (Object)new ServletEnv(this.response, this.request));
        bindings.put("sql", (Object)sqlFacade);
        bindings.put("tx", (Object)runnerContext.getTxFacade());
        bindings.put("types", (Object)runnerContext.getTypesFacade());
        runnerContext.setParams(inputParams);
        PrintWriter printWriter = new PrintWriter(System.err);
        context.setWriter(printWriter);
        context.setAttribute("$SQL", "", 100);
        List<Script> scripts = this.cm.getConfigAndContent(action, method);
        try {
            engine.eval(Utils.getResourceContent("io/lightlink/core/sqlFunctions.js"));
            for (Script script : scripts) {
                String content = script.getContent();
                String filePath = script.getUrl().getFile();
                bindings.put("_scriptName_", (Object)filePath);
                String debugOutput = null;
                if (ConfigManager.isInDebugMode()) {
                    if (script.getName().toLowerCase().endsWith(".js")) {
                        content = "load(\"" + filePath.replaceAll("\"", "\\\"") + "\");";
                    } else {
                        debugOutput = filePath.replaceAll(".js.sql$", ".debug.js");
                        if (debugOutput.matches("^/[A-Z]:.+")) {
                            debugOutput = debugOutput.substring(1);
                        }
                        FileOutputStream fos = new FileOutputStream(debugOutput);
                        fos.write(("//@ sourceURL=" + debugOutput + "\n").getBytes("UTF-8"));
                        fos.write(content.getBytes("UTF-8"));
                        fos.close();
                        content = "load(\"" + debugOutput.replaceAll("\"", "\\\"") + "\");";
                    }
                }
                try {
                    engine.eval(content);
                }
                catch (Exception e) {
                    if (debugOutput != null) {
                        throw new RuntimeException(e.toString() + "\nSEE TRANSLATED JS: " + debugOutput, e);
                    }
                    throw new RuntimeException(e.toString(), e);
                }
                finally {
                    printWriter.flush();
                }
            }
            sqlFacade.query();
            runnerContext.getResponseStream().writeProperty("success", true);
            txFacade.success();
        }
        catch (Throwable e) {
            runnerContext.getResponseStream().writeProperty("success", false);
            runnerContext.getResponseStream().writeProperty("error", e.toString());
            if (ConfigManager.isInDebugMode()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                runnerContext.getResponseStream().writeProperty("stackTrace", sw.toString());
            }
            LogUtils.error(this.getClass(), e);
            txFacade.failure();
        }
        finally {
            sqlFacade.releaseConnection();
        }
        runnerContext.getResponseStream().end();
    }

    private Map<String, Object> getHeadersMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.request != null) {
            Enumeration headerNames = this.request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                String value = this.request.getHeader(key);
                map.put(key, value);
            }
        }
        return map;
    }

    private JSObject newJSObject(ScriptEngine engine) {
        try {
            return (JSObject)engine.eval("({})");
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }
}

