/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.dao;

import io.lightlink.core.ScriptRunner;
import io.lightlink.dao.mapping.BeanMapper;
import io.lightlink.output.ObjectBufferResponseStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.collections.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightLinkDAO {
    public static final Logger LOG = LoggerFactory.getLogger(LightLinkDAO.class);
    private String rootPackage;
    private String action;
    private ScriptRunner scriptRunner;
    private ServletContext servletContext;

    public LightLinkDAO(String rootPackage, String action, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.rootPackage = rootPackage;
        this.action = action;
        this.scriptRunner = new ScriptRunner(rootPackage, servletContext);
    }

    protected LightLinkDAO(String rootPackage, String action) {
        this.rootPackage = rootPackage;
        this.action = action;
        this.scriptRunner = new ScriptRunner(rootPackage);
    }

    public static LightLinkDAO getInstance(ServletContext servletContext, String rootPackage, String action) {
        return new LightLinkDAO(rootPackage, action);
    }

    public static LightLinkDAO getInstance(String rootPackage, String action) {
        return new LightLinkDAO(rootPackage, action);
    }

    public static LightLinkDAO getInstance(String action) {
        return new LightLinkDAO("lightlink", action);
    }

    public Map<String, Object> execute(Object params) {
        try {
            return this.doExecute(params);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    public <T> T execute(Object params, Class<T> aClass) {
        try {
            Map<String, Object> data = this.doExecute(params);
            return (T)new BeanMapper(aClass, this.getFieldNames(data)).convertObject(data, false);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    private List<String> getFieldNames(Map<String, Object> data) {
        return new ArrayList<String>(data.keySet());
    }

    private List<String> getFieldNames(List<Map<String, Object>> data) {
        if (data.size() > 0) {
            return this.getFieldNames(data.get(0));
        }
        return Collections.emptyList();
    }

    public List<Map<String, Object>> queryForList(Object params) {
        try {
            Map<String, Object> data = this.doExecute(params);
            return (List)data.get("resultSet");
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    public <T> List<T> queryForList(Object params, Class<T> aClass) {
        try {
            Map<String, Object> data = this.doExecute(params);
            List resultSet = (List)data.get("resultSet");
            if (resultSet != null) {
                return new BeanMapper(aClass, this.getFieldNames(resultSet)).convert(resultSet);
            }
            return null;
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    public <T> T queryForSingleRow(Object params, Class<T> aClass) {
        try {
            Map<String, Object> data = this.doExecute(params);
            List resultSet = (List)data.get("resultSet");
            if (resultSet != null) {
                return (T)new BeanMapper(aClass, this.getFieldNames(resultSet)).convert(resultSet).get(0);
            }
            throw new IndexOutOfBoundsException("No resultSet returned");
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    public Map<String, Object> queryForSingleRow(Object params) {
        try {
            Map<String, Object> data = this.doExecute(params);
            Object resultSet = data.get("resultSet");
            if (resultSet != null) {
                return (Map)((List)data.get("resultSet")).get(0);
            }
            throw new IndexOutOfBoundsException("No resultSet returned");
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    protected Map<String, Object> doExecute(Object params) throws IOException {
        Map paramsMap = params instanceof Map ? (Map)params : new BeanMap(params);
        ObjectBufferResponseStream responseStream = new ObjectBufferResponseStream();
        this.scriptRunner.execute(this.action, "", paramsMap, responseStream);
        return responseStream.getDataMap();
    }
}

