/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.dao.mapping;

import io.lightlink.dao.mapping.MappingEntry;
import io.lightlink.dao.mapping.MappingUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMapper {
    public static final Logger LOG = LoggerFactory.getLogger(BeanMapper.class);
    Class paramClass;
    List<String> ownFields = new ArrayList<String>();
    Map<String, BeanMapper> childMappers = new CaseInsensitiveMap();
    Map<String, BeanMapper> childListMappers = new CaseInsensitiveMap();
    Map<MappingEntry, Object> pool = new HashMap<MappingEntry, Object>();
    private final Map<String, PropertyDescriptor> descriptorMap;

    public BeanMapper(Class paramClass, List<String> fieldsOfLine) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Class)paramClass);
        this.descriptorMap = new CaseInsensitiveMap();
        for (PropertyDescriptor descriptor : descriptors) {
            this.descriptorMap.put(this.normalizePropertyName(descriptor.getName()), descriptor);
        }
        ArrayList<String> ownFields = new ArrayList<String>();
        CaseInsensitiveMap fieldsByChild = new CaseInsensitiveMap();
        BeanMapper.groupFields(fieldsOfLine, ownFields, (Map<String, List<String>>)fieldsByChild);
        this.ownFields = ownFields;
        for (Map.Entry entry : fieldsByChild.entrySet()) {
            String childProperty = this.normalizePropertyName((String)entry.getKey());
            PropertyDescriptor descriptor = this.descriptorMap.get(childProperty);
            if (descriptor != null) {
                List properties = (List)entry.getValue();
                if (descriptor.getPropertyType().isAssignableFrom(ArrayList.class)) {
                    Type[] typeArguments = ((ParameterizedType)descriptor.getReadMethod().getGenericReturnType()).getActualTypeArguments();
                    if (typeArguments.length == 0) {
                        throw new RuntimeException("Cannot define Generic list type of " + (String)entry.getKey() + " property of " + paramClass);
                    }
                    Type firstType = typeArguments[0];
                    if (!(firstType instanceof Class)) continue;
                    this.childListMappers.put(childProperty, new BeanMapper((Class)firstType, properties));
                    continue;
                }
                this.childMappers.put(childProperty, new BeanMapper(descriptor.getPropertyType(), properties));
                continue;
            }
            throw new RuntimeException("cannot define mapping for class:" + paramClass.getName() + " property:" + childProperty);
        }
        this.paramClass = paramClass;
    }

    public static void groupFields(List<String> allFieldsOfLine, List<String> ownFields, Map<String, List<String>> fieldsByChild) {
        for (String f : allFieldsOfLine) {
            if (f.contains(".")) {
                int dotPos = f.indexOf(46);
                String childName = f.substring(0, dotPos);
                List<String> list = fieldsByChild.get(childName);
                if (list == null) {
                    list = new ArrayList<String>();
                    fieldsByChild.put(childName, list);
                }
                list.add(f.substring(dotPos + 1));
                continue;
            }
            ownFields.add(f);
        }
    }

    public List convert(List<Map<String, Object>> maps) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        if (maps == null) {
            return new ArrayList();
        }
        ArrayList<Object> beanList = new ArrayList<Object>(maps.size());
        for (Map<String, Object> map : maps) {
            Object object = this.convertObject(map, true);
            if (object == null) continue;
            beanList.add(object);
        }
        return beanList;
    }

    public Object convertObject(Map<String, Object> map, boolean returnNullIfAlreadyPresent) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        boolean fromPool;
        Object bean = this.paramClass.newInstance();
        this.populate(bean, map);
        ArrayList<String> fieldsToCompare = new ArrayList<String>(this.ownFields);
        fieldsToCompare.addAll(this.childMappers.keySet());
        MappingEntry mappingEntry = new MappingEntry(this.paramClass, fieldsToCompare, bean);
        Object pooledEntry = this.pool.get(mappingEntry);
        if (pooledEntry != null) {
            bean = pooledEntry;
            fromPool = true;
        } else {
            this.pool.put(mappingEntry, bean);
            fromPool = false;
        }
        boolean lineAdded = this.populateListObjects(bean, map);
        if (fromPool && lineAdded && returnNullIfAlreadyPresent) {
            return null;
        }
        return bean;
    }

    private void populate(Object bean, Map<String, Object> map) throws InvocationTargetException, IllegalAccessException {
        CaseInsensitiveMap data = new CaseInsensitiveMap(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            data.put(this.normalizePropertyName(entry.getKey()), entry.getValue());
        }
        this.populateOwnFields(bean, (Map<String, Object>)data);
        this.populateChildObjects(bean, map);
    }

    private boolean populateListObjects(Object bean, Map<String, Object> map) {
        boolean lineAdded = false;
        for (Map.Entry<String, BeanMapper> entry : this.childListMappers.entrySet()) {
            String originalKey = entry.getKey();
            String key = this.normalizePropertyName(entry.getKey());
            PropertyDescriptor propertyDescriptor = this.descriptorMap.get(key);
            if (propertyDescriptor == null) {
                LOG.info("Cannot find property for " + entry.getKey() + " in class " + this.paramClass.getCanonicalName());
                continue;
            }
            Map<String, Object> childData = this.prepareChildData(originalKey, map);
            try {
                Object childObject = entry.getValue().convertObject(childData, true);
                ArrayList<Object> list = (ArrayList<Object>)propertyDescriptor.getReadMethod().invoke(bean, new Object[0]);
                if (list == null) {
                    propertyDescriptor.getWriteMethod().invoke(bean, list = new ArrayList<Object>());
                }
                if (childObject != null) {
                    list.add(childObject);
                }
                lineAdded = true;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return lineAdded;
    }

    private Map<String, Object> prepareChildData(String originalKey, Map<String, Object> map) {
        CaseInsensitiveMap childData = new CaseInsensitiveMap(map.size());
        for (Map.Entry<String, Object> childEntry : map.entrySet()) {
            String childEntryKey = childEntry.getKey();
            if (!childEntryKey.startsWith(originalKey + ".")) continue;
            childData.put(childEntryKey.substring(originalKey.length() + 1), childEntry.getValue());
        }
        return childData;
    }

    private void populateChildObjects(Object bean, Map<String, Object> map) {
        for (Map.Entry<String, BeanMapper> entry : this.childMappers.entrySet()) {
            String originalKey = entry.getKey();
            String key = this.normalizePropertyName(originalKey);
            PropertyDescriptor propertyDescriptor = this.descriptorMap.get(key);
            if (propertyDescriptor == null) {
                LOG.info("Cannot find property for " + key + " in class " + this.paramClass.getCanonicalName());
                continue;
            }
            Map<String, Object> childData = this.prepareChildData(originalKey, map);
            try {
                Object childObject = entry.getValue().convertObject(childData, false);
                propertyDescriptor.getWriteMethod().invoke(bean, childObject);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void populateOwnFields(Object bean, Map<String, Object> data) {
        for (String field : this.ownFields) {
            String key = this.normalizePropertyName(field);
            PropertyDescriptor propertyDescriptor = this.descriptorMap.get(key);
            if (propertyDescriptor == null) {
                LOG.info("Cannot find property for " + field + " in class " + this.paramClass.getCanonicalName());
                continue;
            }
            try {
                propertyDescriptor.getWriteMethod().invoke(bean, MappingUtils.convert(propertyDescriptor.getPropertyType(), data.get(key), propertyDescriptor.getName()));
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String normalizePropertyName(String key) {
        return key.replaceAll("_", "");
    }
}

