/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.dao.mapping;

import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingEntry {
    public static final Logger LOG = LoggerFactory.getLogger(MappingEntry.class);
    private Class className;
    private List<String> usedProperties;
    private Object object;

    public MappingEntry(Class className, List<String> usedProperties, Object object) {
        this.className = className;
        this.usedProperties = usedProperties;
        this.object = object;
    }

    public Class getClassName() {
        return this.className;
    }

    public void setClassName(Class className) {
        this.className = className;
    }

    public List<String> getUsedProperties() {
        return this.usedProperties;
    }

    public void setUsedProperties(List<String> usedProperties) {
        this.usedProperties = usedProperties;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingEntry entry = (MappingEntry)o;
        if (this.className != null ? !this.className.equals(entry.className) : entry.className != null) {
            return false;
        }
        if (this.usedProperties != null ? !this.usedProperties.equals(entry.usedProperties) : entry.usedProperties != null) {
            return false;
        }
        try {
            if (this.usedProperties != null) {
                for (String property : this.usedProperties) {
                    Object p2;
                    Object p1 = PropertyUtils.getProperty((Object)this.object, (String)property);
                    if (p1 == (p2 = PropertyUtils.getProperty((Object)entry.getObject(), (String)property)) || p1 != null && p2 != null && p1.equals(p2)) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return true;
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.usedProperties != null ? this.usedProperties.hashCode() : 0);
        try {
            if (this.usedProperties != null) {
                for (String property : this.usedProperties) {
                    Object p = PropertyUtils.getProperty((Object)this.object, (String)property);
                    result = 31 * result + (p != null ? p.hashCode() : 0);
                }
            }
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new RuntimeException(e);
        }
        return result;
    }
}

