/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.dao.mapping;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

public class MappingUtils {
    public static Object convert(Class<?> propertyType, Object value, String propertyName) {
        if (value == null || propertyType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if ((Byte.TYPE.equals(propertyType) || Byte.class.equals(propertyType)) && value.getClass().isArray()) {
            return value;
        }
        if (value.getClass().isArray()) {
            Object[] valuesArray = (Object[])value;
            if (propertyType.isArray()) {
                Object[] newArray = (Object[])Array.newInstance(propertyType, valuesArray.length);
                for (int i = 0; i < valuesArray.length; ++i) {
                    Object v = valuesArray[i];
                    newArray[i] = MappingUtils.convert(propertyType.getComponentType(), v, propertyName);
                }
                return newArray;
            }
            if (Collection.class.isAssignableFrom(propertyType)) {
                return Arrays.asList(valuesArray);
            }
        } else {
            if (Boolean.class.equals(propertyType) || Boolean.TYPE.equals(propertyType)) {
                if (value instanceof Number) {
                    return ((Number)value).intValue() != 0;
                }
                return !"0".equals(value.toString()) && !"".equals(value.toString());
            }
            if (value instanceof BigDecimal) {
                BigDecimal v = (BigDecimal)value;
                if (Integer.TYPE.equals(propertyType) || Integer.class.equals(propertyType)) {
                    return v.intValue();
                }
                if (Long.TYPE.equals(propertyType) || Long.class.equals(propertyType)) {
                    return v.longValue();
                }
                if (Float.TYPE.equals(propertyType) || Float.class.equals(propertyType)) {
                    return Float.valueOf(v.floatValue());
                }
                if (Double.TYPE.equals(propertyType) || Double.class.equals(propertyType)) {
                    return v.doubleValue();
                }
                if (String.class.equals(propertyType)) {
                    return v.toString();
                }
                return v.shortValue();
            }
            if (java.sql.Date.class.equals(propertyType)) {
                return new java.sql.Date(((Date)value).getTime());
            }
            if (value instanceof Date) {
                return new Date(((Date)value).getTime());
            }
            if (propertyType.isAssignableFrom(String.class)) {
                return value.toString();
            }
            if ((Long.class.equals(propertyType) || Long.TYPE.equals(propertyType)) && value instanceof String) {
                return new Long((String)value);
            }
            if ((Integer.class.equals(propertyType) || Integer.TYPE.equals(propertyType)) && value instanceof String) {
                return new Integer((String)value);
            }
            if ((Double.class.equals(propertyType) || Double.TYPE.equals(propertyType)) && value instanceof String) {
                return new Double((String)value);
            }
            if ((Float.class.equals(propertyType) || Float.TYPE.equals(propertyType)) && value instanceof String) {
                return new Float((String)value);
            }
        }
        throw new RuntimeException("Cannot convert for property:" + propertyName + " from:" + value.getClass().getCanonicalName() + " to " + propertyType.getCanonicalName() + " value:" + value);
    }
}

