/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.facades;

import io.lightlink.core.RunnerContext;
import io.lightlink.output.ObjectBufferResponseStream;
import io.lightlink.output.ResponseStream;
import io.lightlink.sql.SQLHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.script.ScriptException;
import javax.sql.DataSource;
import jdk.nashorn.api.scripting.JSObject;

public class SQLFacade {
    private int fetchSize = 100;
    private Integer maxRows = null;
    private Integer queryTimeout = null;
    boolean autoCommit = true;
    DataSource dataSource;
    Connection connection;
    RunnerContext runnerContext;
    private SQLHandler sqlHandler = new SQLHandler(this);
    private List<Integer> updateCount;
    private List<SQLFacade> childInstances = new ArrayList<SQLFacade>();

    public SQLFacade(RunnerContext runnerContext) {
        this.runnerContext = runnerContext;
    }

    public SQLFacade newInstance() throws SQLException {
        SQLFacade newFacade = new SQLFacade(this.runnerContext);
        newFacade.setAutoCommit(this.autoCommit);
        this.childInstances.add(newFacade);
        return newFacade;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        if (this.connection != null) {
            this.connection.setAutoCommit(autoCommit);
        }
    }

    public void queryForValue(String propertyName) throws SQLException, IOException, ScriptException {
        Map line;
        ResponseStream resp = this.runnerContext.getResponseStream();
        List res = (List)this.queryToBuffer();
        if (res.size() > 0 && (line = (Map)res.get(0)).size() > 0) {
            resp.writeProperty(propertyName, line.entrySet().iterator().next().getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object queryToBuffer() throws SQLException, IOException, ScriptException {
        ResponseStream respBackup = this.runnerContext.getResponseStream();
        try {
            ObjectBufferResponseStream buffer = new ObjectBufferResponseStream();
            this.runnerContext.setResponseStream(buffer);
            this.runnerContext.getUsedResultSetNames().remove("buffer");
            this.query("buffer");
            Map<String, Object> res = buffer.getDataMap();
            Object object = res.get("buffer");
            return object;
        }
        finally {
            this.runnerContext.setResponseStream(respBackup);
        }
    }

    public void query() throws SQLException, IOException, ScriptException {
        this.query(null);
    }

    public void query(String resultSetName) throws SQLException, IOException, ScriptException {
        this.query(resultSetName, null);
    }

    public void query(String resultSetName, JSObject rowHandler) throws SQLException, IOException, ScriptException {
        this.query(false, resultSetName, rowHandler);
    }

    public void addBatch() throws SQLException, IOException, ScriptException {
        this.addBatch(null);
    }

    public void addBatch(String resultSetName) throws SQLException, IOException, ScriptException {
        this.addBatch(resultSetName, null);
    }

    public void addBatch(String resultSetName, JSObject rowHandler) throws SQLException, IOException, ScriptException {
        this.query(true, resultSetName, rowHandler);
    }

    public void query(boolean addBatch, String resultSetName, JSObject rowHandler) throws SQLException, IOException, ScriptException {
        String sql = this.runnerContext.getAndClearSQLBuffer();
        this.sqlHandler.query(addBatch, resultSetName, this.runnerContext, sql, rowHandler);
        this.runnerContext.clearParams();
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.dataSource != null) {
            this.connection = this.dataSource.getConnection();
            return this.connection;
        }
        throw new IllegalArgumentException("Neither Connection nor DataSourceJndi not provided. See config.js, sql.setJDBCConnection() or sql.setDataSourceJndi() ");
    }

    public void setConnection(Connection connection) throws SQLException {
        if (connection != null) {
            this.releaseConnection();
        }
        this.connection = connection;
    }

    public void setConnection(String className, String url, String login, String password) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        Class.forName(className).newInstance();
        Connection connection = DriverManager.getConnection(url, login, password);
        this.setConnection(connection);
    }

    public void setDataSourceJndi(String jndi) throws NamingException, SQLException {
        if (this.connection != null) {
            this.releaseConnection();
        }
        InitialContext initialContext = new InitialContext();
        this.dataSource = (DataSource)initialContext.lookup(jndi);
        if (this.dataSource == null) {
            throw new RuntimeException("DataSource " + jndi + " font found in InitialContext");
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Integer queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void releaseConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (SQLFacade childInstance : this.childInstances) {
            childInstance.releaseConnection();
        }
    }

    public void setUpdateCount(List<Integer> updateCount) {
        this.updateCount = updateCount;
    }

    public int getUpdateCount(int n) {
        if (this.updateCount != null && n < this.updateCount.size()) {
            return this.updateCount.get(n);
        }
        return -1;
    }

    public int getUpdateCount() {
        return this.getUpdateCount(0);
    }

    public void commit() {
        try {
            if (this.connection != null && !this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot commit : " + e.toString(), e);
        }
        for (SQLFacade childInstance : this.childInstances) {
            childInstance.commit();
        }
    }

    public void rollback() {
        try {
            if (this.connection != null && !this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot rollback : " + e.toString(), e);
        }
        for (SQLFacade childInstance : this.childInstances) {
            childInstance.rollback();
        }
    }
}

