/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.facades;

import io.lightlink.core.RunnerContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;

public class TxFacade {
    private RunnerContext runnerContext;
    private TransactionManager tm;
    private boolean rollbackOnly;

    public TxFacade(RunnerContext runnerContext) {
        this.runnerContext = runnerContext;
    }

    public void useTxJee(String jndi) throws NamingException, NotSupportedException {
        InitialContext context = new InitialContext();
        try {
            this.tm = (TransactionManager)context.lookup(jndi);
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (this.tm == null) {
            throw new IllegalArgumentException("Called useYxJee('" + jndi + "') but no TransactionManager found under this name ");
        }
        try {
            this.tm.begin();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public void useTxJee() throws NamingException, NotSupportedException {
        InitialContext context = new InitialContext();
        try {
            this.tm = (TransactionManager)context.lookup("java:/comp/TransactionManager");
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (this.tm == null) {
            try {
                this.tm = (TransactionManager)context.lookup("java:/TransactionManager");
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        if (this.tm == null) {
            throw new IllegalArgumentException("No TransactionManager in JNDI. Tried both java:/TransactionManager and java:/comp/TransactionManager");
        }
        try {
            this.tm.begin();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public void setTxTimeout(int timeout) {
        if (this.tm != null) {
            try {
                this.tm.setTransactionTimeout(timeout);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
    }

    public void setTxRollbackOnly() {
        if (this.tm != null) {
            try {
                this.tm.setRollbackOnly();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString(), e);
            }
        } else {
            this.rollbackOnly = true;
        }
    }

    public void success() throws HeuristicRollbackException, RollbackException, HeuristicMixedException {
        if (this.tm != null) {
            try {
                this.tm.commit();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString(), e);
            }
        } else if (this.rollbackOnly) {
            this.runnerContext.getRootSQLFacade().rollback();
        } else {
            this.runnerContext.getRootSQLFacade().commit();
        }
    }

    public void failure() {
        if (this.tm != null) {
            try {
                this.tm.rollback();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString(), e);
            }
        } else {
            this.runnerContext.getRootSQLFacade().rollback();
        }
    }
}

