/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.oracle;

import io.lightlink.core.RunnerContext;
import io.lightlink.oracle.AbstractOracleType;
import java.io.IOException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class OracleArrayType
extends AbstractOracleType {
    @Override
    public Object convertToJdbc(Connection connection, RunnerContext runnerContext, String name, Object value) throws IOException, SQLException {
        OracleConnection con = this.unwrap(connection);
        ArrayDescriptor arrayStructDesc = this.safeCreateArrayDescriptor(this.getCustomSQLTypeName(), con);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return new ARRAY(arrayStructDesc, (Connection)con, (Object)((List)value).toArray());
        }
        throw new IllegalArgumentException("Type " + this.getCustomSQLTypeName() + " of converter=" + this.getClass().getName() + " accepts array/list of values.");
    }

    @Override
    public Object readFromResultSet(ResultSet resultSet, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        Array array = resultSet.getArray(pos);
        return array != null ? array.getArray() : null;
    }

    @Override
    public Object readFromCallableStatement(CallableStatement cs, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        Array array = cs.getArray(pos);
        return array != null ? array.getArray() : null;
    }

    @Override
    public Integer getSQLType() {
        return 2003;
    }
}

