/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.oracle;

import io.lightlink.core.RunnerContext;
import io.lightlink.oracle.AbstractOracleType;
import java.io.IOException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.STRUCT;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class OracleStructArrayType
extends AbstractOracleType {
    @Override
    public Object convertToJdbc(Connection connection, RunnerContext runnerContext, String name, Object value) throws IOException, SQLException {
        OracleConnection con = this.unwrap(connection);
        ArrayDescriptor arrayStructDesc = this.safeCreateArrayDescriptor(this.getCustomSQLTypeName(), con);
        if (value == null) {
            return null;
        }
        if (value instanceof List || value.getClass().isArray()) {
            if (value.getClass().isArray()) {
                value = Arrays.asList((Object[])value);
            }
            List records = value;
            STRUCT[] structArray = new STRUCT[records.size()];
            for (int i = 0; i < structArray.length; ++i) {
                Object record = records.get(i);
                if (!(record instanceof Map)) {
                    CaseInsensitiveMap map = new CaseInsensitiveMap((Map)new BeanMap(record));
                    map.remove("class");
                    record = map;
                }
                structArray[i] = this.createStructFromMap(con, (Map)record, arrayStructDesc.getBaseName());
            }
            return new ARRAY(arrayStructDesc, (Connection)con, (Object)structArray);
        }
        throw new IllegalArgumentException("Type " + this.getCustomSQLTypeName() + " of converter=" + this.getClass().getName() + " accepts array/list of objects.");
    }

    @Override
    public Object readFromResultSet(ResultSet resultSet, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        throw new IllegalArgumentException("Obtaining ARRAY of STRUCT type from SQL is not implemented.");
    }

    @Override
    public Object readFromCallableStatement(CallableStatement cs, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        Array array = cs.getArray(pos);
        return this.getDataFromArray(this.unwrap(cs.getConnection()), array);
    }

    private Object getDataFromArray(OracleConnection con, Array array) throws SQLException {
        Object[] structs;
        if (array == null) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Object struct : structs = (Object[])array.getArray()) {
            Struct structure = (Struct)struct;
            list.add(this.getMapFromStruct(con, structure));
        }
        return list;
    }

    @Override
    public Integer getSQLType() {
        return 2003;
    }
}

