/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.oracle;

import io.lightlink.core.RunnerContext;
import io.lightlink.oracle.AbstractOracleType;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class OracleStructType
extends AbstractOracleType {
    @Override
    public Object convertToJdbc(Connection connection, RunnerContext runnerContext, String name, Object value) throws IOException, SQLException {
        OracleConnection con = this.unwrap(connection);
        if (!(value instanceof Map)) {
            CaseInsensitiveMap map = new CaseInsensitiveMap((Map)new BeanMap(value));
            map.remove("class");
            value = map;
        }
        return this.createStructFromMap(con, (Map)value, this.getCustomSQLTypeName());
    }

    @Override
    public Object readFromResultSet(ResultSet resultSet, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        throw new IllegalArgumentException("Obtaining STRUCT type from SQL is not implemented.");
    }

    @Override
    public Object readFromCallableStatement(CallableStatement cs, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        OracleCallableStatement ocs = cs.unwrap(OracleCallableStatement.class);
        return this.getMapFromStruct(this.unwrap(ocs.getConnection()), (Struct)ocs.getSTRUCT(pos));
    }

    @Override
    public Integer getSQLType() {
        return 2002;
    }
}

