/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.output;

import io.lightlink.config.ConfigManager;
import io.lightlink.core.Hints;
import io.lightlink.core.RunnerContext;
import io.lightlink.facades.TypesFacade;
import io.lightlink.output.ResponseStream;
import io.lightlink.security.AntiXSS;
import io.lightlink.spring.LightLinkFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import jdk.nashorn.api.scripting.JSObject;
import org.apache.commons.beanutils.BeanMap;

public class JSONResponseStream
implements ResponseStream {
    public static final String PROGRESSIVE_KEY_STR = "\n\t \t\n";
    public static final byte[] PROGRESSIVE_KEY = "\n\t \t\n".getBytes();
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final byte[] TOKEN_ARR_START = "\":[".getBytes();
    public static final byte[] TOKEN_OBJ_START = "\":{".getBytes();
    public static final String STR_QUOT = "\\\"";
    public static final String STR_BACKSLASH = "\\\\";
    public static final String STR_B = "\\b";
    public static final String STR_F = "\\f";
    public static final String STR_N = "\\n";
    public static final String STR_R = "\\r";
    public static final String STR_T = "\\t";
    public static final String STR_SLASH = "\\/";
    public static final String STR_SLASH_U = "\\u";
    boolean ended = false;
    int ident = 0;
    boolean debug = ConfigManager.isInDebugMode();
    RunnerContext runnerContext;
    private boolean commaNeeded;
    private boolean started;
    private int[] progressiveBlockSizes;
    private int currentProgressiveBlock;
    private int currentRowNum;
    private int openBracesCount;
    private boolean antiXSS;
    private OutputStream outputStream;
    private char rootTagOpen = (char)123;
    private char rootTagClose = (char)125;

    public JSONResponseStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.commaNeeded = false;
        this.ident = 0;
        this.ended = false;
        this.started = false;
        this.initHints();
    }

    protected void initHints() {
        Hints hints;
        if (LightLinkFilter.isThreadLocalStreamingDataSet() && (hints = LightLinkFilter.getThreadLocalStreamingData().getHints()) != null) {
            this.progressiveBlockSizes = hints.getProgressiveBlockSizes();
            this.antiXSS = hints.isAntiXSS();
        }
    }

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    public RunnerContext getRunnerContext() {
        return this.runnerContext;
    }

    @Override
    public void setRunnerContext(RunnerContext runnerContext) {
        this.runnerContext = runnerContext;
    }

    private void identIn() {
        this.writeIdent();
        ++this.ident;
    }

    private void identOut() {
        --this.ident;
        this.writeIdent();
    }

    private void writeIdent() {
        if (this.debug) {
            this.write('\n');
            for (int i = 0; i < this.ident; ++i) {
                this.write('\t');
            }
        }
    }

    private void write(char c) {
        try {
            this.outputStream.write(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    protected void write(byte[] byes, int size) {
        try {
            this.outputStream.write(byes, 0, size);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    protected void write(byte[] byes) {
        try {
            this.outputStream.write(byes);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    private void beginIfNeeded() {
        if (!this.started) {
            this.started = true;
            this.write(this.rootTagOpen);
            ++this.openBracesCount;
            ++this.ident;
        }
    }

    @Override
    public synchronized void end() {
        if (!this.ended) {
            this.beginIfNeeded();
            this.write(this.rootTagClose);
            --this.openBracesCount;
            this.ended = true;
        }
    }

    @Override
    public synchronized void writeProperty(String name, Object value) {
        this.beginIfNeeded();
        this.comma();
        this.identIn();
        this.write('\"');
        this.writeEscapedString(name);
        this.write('\"');
        this.write(':');
        this.commaNeeded = false;
        this.writeFullObjectToArray(value);
        --this.ident;
        this.commaNeeded = true;
    }

    @Override
    public synchronized void writeFullObjectToArray(Object value) {
        this.beginIfNeeded();
        if (value != null && value.getClass().getName().equals("jdk.nashorn.api.scripting.JSObject")) {
            JSObject jsObject = (JSObject)value;
            if (jsObject.isArray()) {
                Object[] array = new Object[((Number)jsObject.getMember("length")).intValue()];
                this.writeArrayStart();
                for (int i = 0; i < array.length; ++i) {
                    this.writeFullObjectToArray(this.genericDateConvert(jsObject.getSlot(i)));
                }
                this.writeArrayEnd();
            } else {
                this.writeObjectStart();
                for (String key : jsObject.keySet()) {
                    this.writeProperty(key, this.genericDateConvert(jsObject.getMember(key)));
                }
                this.writeObjectEnd();
            }
        } else {
            this.comma();
            ArrayList list = new ArrayList();
            value = this.handlePrimitiveArrays(value, list);
            if (value instanceof Map) {
                this.writeObjectStart();
                Map map = (Map)value;
                if (value instanceof BeanMap) {
                    for (Map.Entry entry : map.entrySet()) {
                        if ("class".equals(entry.getKey())) continue;
                        this.writeProperty(entry.getKey() + "", entry.getValue());
                    }
                } else {
                    for (Map.Entry entry : map.entrySet()) {
                        this.writeProperty(entry.getKey() + "", entry.getValue());
                    }
                }
                this.writeObjectEnd();
            } else if (value instanceof List) {
                this.writeArrayStart();
                for (Object o : (List)value) {
                    this.writeFullObjectToArray(o);
                }
                this.writePropertyArrayEnd();
            } else if (value instanceof InputStream) {
                this.writeInputStream((InputStream)value);
            } else if (value instanceof Reader) {
                this.writeFromReader((Reader)value);
            } else if (value instanceof Object[]) {
                this.writeArrayStart();
                for (Object o : (Object[])value) {
                    this.writeFullObjectToArray(o);
                }
                this.writeArrayEnd();
            } else if (value instanceof Date) {
                String dateFormat;
                if (this.getRunnerContext() != null && this.getRunnerContext().getTypesFacade().getCustomDatePattern() != null) {
                    TypesFacade tf = this.getRunnerContext().getTypesFacade();
                    dateFormat = tf.getCustomDatePattern();
                } else {
                    dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
                }
                this.writeString(new SimpleDateFormat(dateFormat).format(value));
            } else if (value == null) {
                this.writeUnquoted("null");
            } else if (value instanceof Number || value instanceof Boolean) {
                this.writeUnquoted(value);
            } else {
                this.writeString(value.toString());
            }
            this.commaNeeded = true;
        }
    }

    public void writeUnquoted(Object value) {
        ByteBuffer byteBuffer = CHARSET.encode(value.toString());
        this.write(byteBuffer.array(), byteBuffer.remaining());
    }

    public void writeFromReader(Reader reader) {
        this.write('\"');
        char[] buffer = new char[16000];
        long count = 0L;
        int n = 0;
        try {
            while (-1 != (n = reader.read(buffer))) {
                ByteBuffer bbuffer = CHARSET.encode(CharBuffer.wrap(buffer, 0, n));
                this.write(bbuffer.array(), bbuffer.remaining());
                count += (long)n;
            }
            this.write('\"');
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public void writeInputStream(InputStream inputStream) {
        this.write('\"');
        byte[] buffer = new byte[3072];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                String encodedBlock;
                if (length < buffer.length) {
                    byte[] part = new byte[length];
                    System.arraycopy(buffer, 0, part, 0, length);
                    encodedBlock = DatatypeConverter.printBase64Binary((byte[])part);
                } else {
                    encodedBlock = DatatypeConverter.printBase64Binary((byte[])buffer);
                }
                ByteBuffer bbuffer = CHARSET.encode(encodedBlock);
                this.write(bbuffer.array(), bbuffer.remaining());
            }
            this.write('\"');
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public void writeString(String valueStr) {
        if (this.antiXSS) {
            valueStr = AntiXSS.escape(valueStr);
        }
        this.write('\"');
        this.writeEscapedString(valueStr);
        this.write('\"');
    }

    private void writeEscapedString(String valueStr) {
        char[] chars = valueStr.toCharArray();
        StringBuffer sb = new StringBuffer(valueStr);
        block10: for (int i = chars.length - 1; i >= 0; --i) {
            char ch = chars[i];
            switch (ch) {
                case '\"': {
                    sb.replace(i, i + 1, STR_QUOT);
                    continue block10;
                }
                case '\\': {
                    sb.replace(i, i + 1, STR_BACKSLASH);
                    continue block10;
                }
                case '\b': {
                    sb.replace(i, i + 1, STR_B);
                    continue block10;
                }
                case '\f': {
                    sb.replace(i, i + 1, STR_F);
                    continue block10;
                }
                case '\n': {
                    sb.replace(i, i + 1, STR_N);
                    continue block10;
                }
                case '\r': {
                    sb.replace(i, i + 1, STR_R);
                    continue block10;
                }
                case '\t': {
                    sb.replace(i, i + 1, STR_T);
                    continue block10;
                }
                case '/': {
                    sb.replace(i, i + 1, STR_SLASH);
                    continue block10;
                }
                default: {
                    if (!(ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f') && (ch < '\u2000' || ch > '\u20ff')) continue block10;
                    StringBuilder encoded = new StringBuilder();
                    String ss = Integer.toHexString(ch).toUpperCase();
                    encoded.append(STR_SLASH_U);
                    for (int k = 0; k < 4 - ss.length(); ++k) {
                        encoded.append('0');
                    }
                    encoded.append(ss.toUpperCase());
                    sb.replace(i, i + 1, encoded.toString());
                }
            }
        }
        ByteBuffer buffer = CHARSET.encode(sb.toString());
        this.write(buffer.array(), buffer.remaining());
    }

    private Object handlePrimitiveArrays(Object value, List list) {
        if (value instanceof byte[]) {
            for (byte b : (byte[])value) {
                list.add(b);
            }
            value = list;
        } else if (value instanceof short[]) {
            for (short b : (short[])value) {
                list.add(b);
            }
            value = list;
        } else if (value instanceof int[]) {
            for (int b : (int[])value) {
                list.add(b);
            }
            value = list;
        } else if (value instanceof long[]) {
            for (long b : (long[])value) {
                list.add(b);
            }
            value = list;
        } else if (value instanceof float[]) {
            for (float b : (float[])value) {
                list.add(Float.valueOf(b));
            }
        } else if (value instanceof double[]) {
            for (double b : (double[])value) {
                list.add(b);
            }
            value = list;
        }
        return value;
    }

    private Object genericDateConvert(Object value) {
        if (value instanceof Date) {
            value = this.runnerContext.getTypesFacade().dateToString((Date)value);
        }
        return value;
    }

    @Override
    public synchronized void writePropertyObjectStart(String name) {
        this.beginIfNeeded();
        this.comma();
        this.identIn();
        this.write('\"');
        this.writeEscapedString(name);
        this.write(TOKEN_OBJ_START);
        ++this.openBracesCount;
        this.commaNeeded = false;
    }

    @Override
    public synchronized void writePropertyObjectEnd() {
        this.beginIfNeeded();
        this.identOut();
        this.write('}');
        --this.openBracesCount;
        this.commaNeeded = true;
    }

    @Override
    public synchronized void writePropertyArrayStart(String name) {
        this.beginIfNeeded();
        this.comma();
        this.identIn();
        this.write('\"');
        this.writeEscapedString(name);
        this.write(TOKEN_ARR_START);
        this.currentProgressiveBlock = 0;
        this.currentRowNum = 0;
        this.commaNeeded = false;
    }

    @Override
    public synchronized void writePropertyArrayEnd() {
        this.writeArrayEnd();
    }

    @Override
    public synchronized void writeObjectStart() {
        this.beginIfNeeded();
        this.comma();
        this.identIn();
        this.write('{');
        ++this.openBracesCount;
        this.commaNeeded = false;
    }

    @Override
    public synchronized void writeObjectEnd() {
        this.beginIfNeeded();
        this.identOut();
        this.write('}');
        --this.openBracesCount;
        this.commaNeeded = true;
        this.progressiveLoadingSupport();
    }

    public void writeArrayStart() {
        if (!this.started) {
            this.rootTagOpen = (char)91;
            this.rootTagClose = (char)93;
            this.beginIfNeeded();
        } else {
            this.beginIfNeeded();
            this.comma();
            this.identIn();
            this.write('[');
            this.currentProgressiveBlock = 0;
            this.currentRowNum = 0;
            this.commaNeeded = false;
        }
    }

    @Override
    public boolean checkConnectionAlive() {
        try {
            this.flushBuffer();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void progressiveLoadingSupport() {
        if (this.progressiveBlockSizes != null && this.progressiveBlockSizes.length != 0) {
            ++this.currentRowNum;
            if (this.progressiveBlockSizes.length <= this.currentProgressiveBlock) {
                return;
            }
            int currentBlockSize = this.progressiveBlockSizes[this.currentProgressiveBlock];
            if (this.currentRowNum >= currentBlockSize) {
                ++this.currentProgressiveBlock;
                this.currentRowNum = 0;
                for (int i = 0; i < this.openBracesCount; ++i) {
                    this.write('\t');
                }
                this.write(PROGRESSIVE_KEY);
                try {
                    this.flushBuffer();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.toString(), e);
                }
            }
        }
    }

    public void writeArrayEnd() {
        this.beginIfNeeded();
        this.identOut();
        this.write(']');
        this.commaNeeded = true;
    }

    private void comma() {
        if (this.commaNeeded) {
            this.write(',');
            this.commaNeeded = false;
        }
    }

    private String encodeQuotes(String name) {
        if (name.indexOf(34) == -1) {
            return name;
        }
        return name.replaceAll("\"", STR_QUOT);
    }

    @Override
    public void setContentType(String value) {
    }

    @Override
    public void setHeader(String header, String value) {
    }

    @Override
    public void flushBuffer() throws IOException {
        this.outputStream.flush();
    }
}

