/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.output.async;

import io.lightlink.output.HttpResponseStream;
import io.lightlink.output.async.NoOpBlockingQueue;
import io.lightlink.output.async.QueueElement;
import io.lightlink.utils.LogUtils;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class AsyncHttpResponseStreamRunnable
implements Runnable {
    BlockingQueue<QueueElement> queue = new LinkedBlockingQueue<QueueElement>(10000);
    HttpResponseStream facade;
    boolean syncMode = false;
    Object target;

    private boolean shouldSwitchToSyncMode(Object[] args) {
        boolean asyncImpossible = false;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (!(arg instanceof InputStream) && !(arg instanceof Reader)) continue;
                asyncImpossible = true;
            }
        }
        return asyncImpossible;
    }

    public AsyncHttpResponseStreamRunnable(HttpResponseStream target) {
        this.target = target;
        this.facade = this.getAsyncProxy(HttpResponseStream.class);
    }

    public HttpResponseStream getFacade() {
        return this.facade;
    }

    private <T> T getAsyncProxy(Class<T> aClass) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{aClass}, (InvocationHandler)new AsyncInvocationHandler());
    }

    @Override
    public void run() {
        try {
            QueueElement queueElement;
            while ((queueElement = this.queue.take()) != null) {
                if (queueElement.getMethod() == null) continue;
                try {
                    queueElement.getMethod().invoke(this.target, queueElement.getArgs());
                }
                catch (IllegalAccessException e) {
                    LogUtils.error(this.getClass(), e);
                }
                catch (InvocationTargetException e) {
                    LogUtils.warn(this.getClass(), e);
                    this.queue = new NoOpBlockingQueue();
                    break;
                }
                if (!queueElement.getMethod().getName().equals("end")) continue;
                this.queue = new NoOpBlockingQueue();
                break;
            }
        }
        catch (InterruptedException e) {
        }
        catch (Throwable t) {
            LogUtils.warn(this.getClass(), t);
        }
    }

    public Object getTarget() {
        return this.target;
    }

    class AsyncInvocationHandler
    implements InvocationHandler {
        AsyncInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (AsyncHttpResponseStreamRunnable.this.shouldSwitchToSyncMode(args)) {
                AsyncHttpResponseStreamRunnable.this.syncMode = true;
                ArrayList elements = new ArrayList();
                AsyncHttpResponseStreamRunnable.this.queue.drainTo(elements);
                LinkedBlockingQueue<QueueElement> syncQueue = new LinkedBlockingQueue<QueueElement>(1);
                syncQueue.addAll(syncQueue);
                BlockingQueue<QueueElement> oldQueue = AsyncHttpResponseStreamRunnable.this.queue;
                AsyncHttpResponseStreamRunnable.this.queue = syncQueue;
                oldQueue.put(new QueueElement(null, null));
            }
            AsyncHttpResponseStreamRunnable.this.queue.put(new QueueElement(method, args));
            return null;
        }
    }
}

