/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.servlet;

import io.lightlink.config.ConfigManager;
import io.lightlink.config.Script;
import io.lightlink.security.CSRFTokensContainer;
import io.lightlink.servlet.AbstractLightLinkServlet;
import io.lightlink.utils.ClasspathScanUtils;
import io.lightlink.utils.LogUtils;
import io.lightlink.utils.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.api.scripting.JSObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class JsMethodsDefinitionServlet
extends AbstractLightLinkServlet {
    private ConfigManager configManager;

    public void init() throws ServletException {
        super.init();
        this.configManager = new ConfigManager(this.getRootPackage(), this.getServletContext());
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/javascript");
        resp.setHeader("Cache-Control", "private, no-store, no-cache, must-revalidate");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", 0L);
        Cookie[] cookies = req.getCookies();
        String debugMethods = "";
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!"lightlink.debug".equalsIgnoreCase(cookie.getName())) continue;
            debugMethods = cookie.getValue();
        }
        PrintWriter writer = resp.getWriter();
        writer.print(this.getDeclarationScript(debugMethods, req));
        if (StringUtils.isNotEmpty((String)debugMethods) && ConfigManager.isInDebugMode()) {
            writer.print("\n// DEBUG PART \n");
            writer.print("\n\n    /***** io/lightlink/core/sqlFunctions.js   - for debugging *****/\n");
            writer.print(Utils.getResourceContent("io/lightlink/core/sqlFunctions.js"));
            writer.print("\n\n    /***** io/lightlink/core/debugProxy.js - for debugging *****/\n");
            writer.print(Utils.getResourceContent("io/lightlink/core/debugProxy.js"));
            writer.print("\n\n    /***** io/lightlink/core/LightLinkDebugSession.js - for debugging *****/\n");
            writer.print(Utils.getResourceContent("io/lightlink/core/LightLinkDebugSession.js"));
        }
        if (ConfigManager.isInDebugMode()) {
            writer.print("\n\n    /***** io/lightlink/core/IDDQD.js - for debugging *****/\n");
            writer.print(Utils.getResourceContent("io/lightlink/core/IDDQD.js"));
        }
        writer.print("\nLL.JsApi.CSRF_Token = '" + CSRFTokensContainer.getInstance(req.getSession()).createNewToken() + "'\n");
        writer.close();
        resp.flushBuffer();
    }

    String getDeclarationScript(String debugMethods, HttpServletRequest req) throws IOException {
        Set<String> services = this.getServicesNames();
        URL definitionScript = Thread.currentThread().getContextClassLoader().getResource("io/lightlink/core/jsApiDefinition.js");
        StringBuilder sb = new StringBuilder(IOUtils.toString((URL)definitionScript));
        String lightLinkUrl = req.getServletPath().split("-api/")[0];
        sb.append("\n\nLL.JsApi.contextPath='").append(req.getContextPath()).append("';\n");
        sb.append("\n\nLL.JsApi.url='").append(req.getContextPath()).append(lightLinkUrl).append("';\n");
        sb.append("\n\nLL.JsApi.appContext='").append(req.getContextPath()).append("';\n\n");
        String[] debugExpressions = debugMethods.split("/");
        for (String service : services) {
            boolean debug = false;
            if (debugMethods != null) {
                for (String debugExpression : debugExpressions) {
                    if (!service.matches(debugExpression.replaceAll("\\*", ".*"))) continue;
                    debug = true;
                    break;
                }
            }
            sb.append("LL.JsApi.").append(debug ? "debugDefine" : "define").append("('").append(service).append("');\n");
        }
        Map<String, String> customServices = this.getCustomServices();
        for (Map.Entry<String, String> entry : customServices.entrySet()) {
            sb.append("LL.JsApi.").append("defineCustomUrl").append("('").append(entry.getKey()).append("','").append(entry.getValue()).append("');\n");
        }
        return sb.toString();
    }

    private Set<String> getServicesNames() throws IOException {
        ArrayList<String> namesFromPackage = ClasspathScanUtils.getAllResources(this.getRootPackage(), this.getServletContext());
        TreeSet<String> services = new TreeSet<String>();
        for (String name : namesFromPackage) {
            if (!name.endsWith(".js.sql") && (!name.endsWith(".js") || name.endsWith(".debug.js")) || (name = name.replaceAll("^[/\\\\]", "").replaceAll("[/\\\\]", ".").replaceAll(".js(.sql)?$", "")).endsWith("config") || Utils.isFirstNonAlphabetic(name)) continue;
            services.add(name);
        }
        return services;
    }

    private Map<String, String> getCustomServices() throws IOException {
        LinkedHashMap<String, String> customServices = new LinkedHashMap<String, String>();
        Script customServicesScript = this.configManager.getScript("#customServices.js", false);
        if (customServicesScript != null) {
            ScriptEngine engine = ConfigManager.getScriptEngine();
            try {
                Object result = engine.eval(customServicesScript.getContent());
                if (result instanceof JSObject) {
                    JSObject jsObject = (JSObject)result;
                    Set keys = jsObject.keySet();
                    for (String key : keys) {
                        customServices.put(key, "" + jsObject.getMember(key));
                    }
                }
            }
            catch (ScriptException e) {
                LogUtils.error(((Object)((Object)this)).getClass(), e);
            }
        }
        return customServices;
    }
}

