/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.servlet;

import io.lightlink.autostop.AutoStopQuery;
import io.lightlink.output.JSONHttpResponseStream;
import io.lightlink.security.CSRFTokensContainer;
import io.lightlink.servlet.RestServlet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsProxyServlet
extends RestServlet {
    @Override
    protected void service(String method, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if ("/csrfTokenRenew".equals(this.getActionName(req))) {
            JSONHttpResponseStream responseStream = new JSONHttpResponseStream(resp);
            responseStream.writeProperty("newToken", CSRFTokensContainer.getInstance(req.getSession()).createNewToken());
            responseStream.end();
        } else {
            super.service(method, req, resp);
        }
    }

    private String getActionName(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        int pos = req.getRequestURI().indexOf(servletPath);
        return req.getRequestURI().substring(pos + servletPath.length());
    }

    @Override
    protected void doServide(String method, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inputParams) throws IOException {
        String csrfToken = CSRFTokensContainer.getToken(inputParams);
        String actionName = this.getActionName(req);
        JSONHttpResponseStream responseStream = new JSONHttpResponseStream(resp);
        if ("/cancelQueries".equals(actionName)) {
            int canceled = AutoStopQuery.getInstance().cancelAllForWindow(csrfToken);
            responseStream.writeProperty("canceledQueries", canceled);
            responseStream.end();
        } else {
            this.getScriptRunner(req, resp).execute(actionName, "POST", inputParams, responseStream);
        }
    }

    @Override
    protected Map<String, Object> getParams(HttpServletRequest req) throws IOException {
        Map inputParams;
        ServletInputStream inputStream = req.getInputStream();
        try {
            inputParams = (Map)new JSONParser().parse((Reader)new InputStreamReader((InputStream)inputStream, "UTF-8"));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        inputStream.close();
        return inputParams;
    }
}

