/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

public class MultipartParameters {
    HttpServletRequest req;
    private FileItemIterator fileItemIterator;
    private FileItemStream fileItemStream;
    private HashMap<String, Object> paramsMap;
    boolean parametersParsed;

    public MultipartParameters(HttpServletRequest req) {
        this.req = req;
    }

    public HashMap<String, Object> getInitialParams() throws IOException, FileUploadException {
        this.paramsMap = new HashMap();
        ServletFileUpload upload = new ServletFileUpload();
        this.fileItemIterator = upload.getItemIterator(this.req);
        this.parseUpToNextStream();
        this.parametersParsed = true;
        return this.paramsMap;
    }

    public boolean hasNextStream() throws IOException, FileUploadException {
        if (!this.parametersParsed) {
            this.parseUpToNextStream();
            this.parametersParsed = true;
        }
        return this.fileItemStream != null;
    }

    public FileItemStream getNextStream() throws IOException, FileUploadException {
        this.fileItemStream = null;
        if (!this.parametersParsed) {
            this.parseUpToNextStream();
        }
        this.parametersParsed = false;
        return this.fileItemStream;
    }

    private void parseUpToNextStream() throws FileUploadException, IOException {
        while (this.fileItemIterator.hasNext()) {
            FileItemStream fItemStream = this.fileItemIterator.next();
            String name = fItemStream.getFieldName();
            if (fItemStream.isFormField()) {
                this.paramsMap.put(name, Streams.asString((InputStream)fItemStream.openStream()));
                continue;
            }
            this.fileItemStream = fItemStream;
            break;
        }
    }

    public HashMap<String, Object> getParamsMap() {
        return this.paramsMap;
    }
}

